/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.quartz;

import com.xiaoleilu.hutool.setting.dialect.Props;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzUtils {
    private static Logger log = LoggerFactory.getLogger(QuartzUtils.class);
    private static String file = "config/tio-quartz.properties";
    private static final List<QuartzTimeVo> jobClasses = new ArrayList<QuartzTimeVo>(10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        QuartzUtils.initJobClasses();
        if (jobClasses.size() <= 0) {
            log.error("\u6587\u4ef6[{}]\u4e2d\u6ca1\u6709\u914d\u7f6e\u5b9a\u65f6\u4efb\u52a1\u7c7b", (Object)file);
            return;
        }
        try {
            Scheduler scheduler = StdSchedulerFactory.getDefaultScheduler();
            int index = 1;
            for (QuartzTimeVo quartzTimeVo : jobClasses) {
                try {
                    Class<?> clazzz = Class.forName(quartzTimeVo.getClazz());
                    JobDetail job = JobBuilder.newJob(clazzz).withIdentity("job-" + index, "group-" + index).build();
                    CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity("trigger-" + index, "group-" + index).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)quartzTimeVo.getCron())).build();
                    Date d = scheduler.scheduleJob(job, (Trigger)trigger);
                    log.info("\u5b9a\u65f6\u4efb\u52a1[{}]\u5df2\u7ecf\u542f\u52a8, cron:{}", (Object)clazzz.getName(), (Object)trigger.getCronExpression());
                }
                catch (ClassNotFoundException e) {
                    log.error(e.toString(), (Throwable)e);
                }
                finally {
                    ++index;
                }
            }
            scheduler.start();
        }
        catch (SchedulerException e) {
            log.error(e.toString(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void initJobClasses() {
        Props props = new Props(file);
        Set set = props.entrySet();
        if (set != null && set.size() > 0) {
            for (Map.Entry entry : set) {
                String clazz = StringUtils.trim((String)((String)entry.getKey()));
                String cron = StringUtils.trim((String)((String)entry.getValue()));
                QuartzTimeVo quartzTimeVo = new QuartzTimeVo(clazz, cron);
                jobClasses.add(quartzTimeVo);
            }
        }
    }

    public static void main(String[] args) {
    }

    private static class QuartzTimeVo {
        private String clazz = null;
        private String cron = null;

        public QuartzTimeVo(String clazz, String cron) {
            this.clazz = clazz;
            this.cron = cron;
        }

        public String getClazz() {
            return this.clazz;
        }

        public String getCron() {
            return this.cron;
        }
    }
}

