/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PackageVersionStatus {
    PUBLISHED("Published"),
    UNFINISHED("Unfinished"),
    UNLISTED("Unlisted"),
    ARCHIVED("Archived"),
    DISPOSED("Disposed"),
    DELETED("Deleted"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PackageVersionStatus> VALUE_MAP;
    private final String value;

    private PackageVersionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PackageVersionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PackageVersionStatus> knownValues() {
        EnumSet<PackageVersionStatus> knownValues = EnumSet.allOf(PackageVersionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PackageVersionStatus.class, PackageVersionStatus::toString);
    }
}

