/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codeartifact.CodeartifactClient;
import software.amazon.awssdk.services.codeartifact.model.ListRepositoriesRequest;
import software.amazon.awssdk.services.codeartifact.model.ListRepositoriesResponse;
import software.amazon.awssdk.services.codeartifact.model.RepositorySummary;

public class ListRepositoriesIterable
implements SdkIterable<ListRepositoriesResponse> {
    private final CodeartifactClient client;
    private final ListRepositoriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRepositoriesIterable(CodeartifactClient client, ListRepositoriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRepositoriesResponseFetcher();
    }

    public Iterator<ListRepositoriesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RepositorySummary> repositories() {
        Function<ListRepositoriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.repositories() != null) {
                return response.repositories().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRepositoriesResponseFetcher
    implements SyncPageFetcher<ListRepositoriesResponse> {
        private ListRepositoriesResponseFetcher() {
        }

        public boolean hasNextPage(ListRepositoriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRepositoriesResponse nextPage(ListRepositoriesResponse previousPage) {
            if (previousPage == null) {
                return ListRepositoriesIterable.this.client.listRepositories(ListRepositoriesIterable.this.firstRequest);
            }
            return ListRepositoriesIterable.this.client.listRepositories((ListRepositoriesRequest)((Object)ListRepositoriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

