/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codebuild.CodeBuildAsyncClient;
import software.amazon.awssdk.services.codebuild.internal.UserAgentUtils;
import software.amazon.awssdk.services.codebuild.model.ListReportsRequest;
import software.amazon.awssdk.services.codebuild.model.ListReportsResponse;

public class ListReportsPublisher
implements SdkPublisher<ListReportsResponse> {
    private final CodeBuildAsyncClient client;
    private final ListReportsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListReportsPublisher(CodeBuildAsyncClient client, ListReportsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListReportsPublisher(CodeBuildAsyncClient client, ListReportsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListReportsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListReportsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> reports() {
        Function<ListReportsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reports() != null) {
                return response.reports().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListReportsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListReportsResponseFetcher
    implements AsyncPageFetcher<ListReportsResponse> {
        private ListReportsResponseFetcher() {
        }

        public boolean hasNextPage(ListReportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListReportsResponse> nextPage(ListReportsResponse previousPage) {
            if (previousPage == null) {
                return ListReportsPublisher.this.client.listReports(ListReportsPublisher.this.firstRequest);
            }
            return ListReportsPublisher.this.client.listReports((ListReportsRequest)((Object)ListReportsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

