/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConformancePackComplianceType {
    COMPLIANT("COMPLIANT"),
    NON_COMPLIANT("NON_COMPLIANT"),
    INSUFFICIENT_DATA("INSUFFICIENT_DATA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConformancePackComplianceType> VALUE_MAP;
    private final String value;

    private ConformancePackComplianceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConformancePackComplianceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConformancePackComplianceType> knownValues() {
        EnumSet<ConformancePackComplianceType> knownValues = EnumSet.allOf(ConformancePackComplianceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConformancePackComplianceType.class, ConformancePackComplianceType::toString);
    }
}

