/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruAsyncClient;
import software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesRequest;
import software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesResponse;
import software.amazon.awssdk.services.devopsguru.model.MonitoredResourceIdentifier;

public class ListMonitoredResourcesPublisher
implements SdkPublisher<ListMonitoredResourcesResponse> {
    private final DevOpsGuruAsyncClient client;
    private final ListMonitoredResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMonitoredResourcesPublisher(DevOpsGuruAsyncClient client, ListMonitoredResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMonitoredResourcesPublisher(DevOpsGuruAsyncClient client, ListMonitoredResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMonitoredResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMonitoredResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MonitoredResourceIdentifier> monitoredResourceIdentifiers() {
        Function<ListMonitoredResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.monitoredResourceIdentifiers() != null) {
                return response.monitoredResourceIdentifiers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMonitoredResourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMonitoredResourcesResponseFetcher
    implements AsyncPageFetcher<ListMonitoredResourcesResponse> {
        private ListMonitoredResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListMonitoredResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMonitoredResourcesResponse> nextPage(ListMonitoredResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListMonitoredResourcesPublisher.this.client.listMonitoredResources(ListMonitoredResourcesPublisher.this.firstRequest);
            }
            return ListMonitoredResourcesPublisher.this.client.listMonitoredResources((ListMonitoredResourcesRequest)((Object)ListMonitoredResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

