/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruClient;
import software.amazon.awssdk.services.devopsguru.model.ProactiveInsightSummary;
import software.amazon.awssdk.services.devopsguru.model.ReactiveInsightSummary;
import software.amazon.awssdk.services.devopsguru.model.SearchInsightsRequest;
import software.amazon.awssdk.services.devopsguru.model.SearchInsightsResponse;

public class SearchInsightsIterable
implements SdkIterable<SearchInsightsResponse> {
    private final DevOpsGuruClient client;
    private final SearchInsightsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchInsightsIterable(DevOpsGuruClient client, SearchInsightsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchInsightsResponseFetcher();
    }

    public Iterator<SearchInsightsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProactiveInsightSummary> proactiveInsights() {
        Function<SearchInsightsResponse, Iterator> getIterator = response -> {
            if (response != null && response.proactiveInsights() != null) {
                return response.proactiveInsights().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    public final SdkIterable<ReactiveInsightSummary> reactiveInsights() {
        Function<SearchInsightsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reactiveInsights() != null) {
                return response.reactiveInsights().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchInsightsResponseFetcher
    implements SyncPageFetcher<SearchInsightsResponse> {
        private SearchInsightsResponseFetcher() {
        }

        public boolean hasNextPage(SearchInsightsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchInsightsResponse nextPage(SearchInsightsResponse previousPage) {
            if (previousPage == null) {
                return SearchInsightsIterable.this.client.searchInsights(SearchInsightsIterable.this.firstRequest);
            }
            return SearchInsightsIterable.this.client.searchInsights((SearchInsightsRequest)((Object)SearchInsightsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

