/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.docdb.model.DocDbRequest;
import software.amazon.awssdk.services.docdb.model.Tag;
import software.amazon.awssdk.services.docdb.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopyDbClusterParameterGroupRequest
extends DocDbRequest
implements ToCopyableBuilder<Builder, CopyDbClusterParameterGroupRequest> {
    private static final SdkField<String> SOURCE_DB_CLUSTER_PARAMETER_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceDBClusterParameterGroupIdentifier").getter(CopyDbClusterParameterGroupRequest.getter(CopyDbClusterParameterGroupRequest::sourceDBClusterParameterGroupIdentifier)).setter(CopyDbClusterParameterGroupRequest.setter(Builder::sourceDBClusterParameterGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDBClusterParameterGroupIdentifier").build()}).build();
    private static final SdkField<String> TARGET_DB_CLUSTER_PARAMETER_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetDBClusterParameterGroupIdentifier").getter(CopyDbClusterParameterGroupRequest.getter(CopyDbClusterParameterGroupRequest::targetDBClusterParameterGroupIdentifier)).setter(CopyDbClusterParameterGroupRequest.setter(Builder::targetDBClusterParameterGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDBClusterParameterGroupIdentifier").build()}).build();
    private static final SdkField<String> TARGET_DB_CLUSTER_PARAMETER_GROUP_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetDBClusterParameterGroupDescription").getter(CopyDbClusterParameterGroupRequest.getter(CopyDbClusterParameterGroupRequest::targetDBClusterParameterGroupDescription)).setter(CopyDbClusterParameterGroupRequest.setter(Builder::targetDBClusterParameterGroupDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDBClusterParameterGroupDescription").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CopyDbClusterParameterGroupRequest.getter(CopyDbClusterParameterGroupRequest::tags)).setter(CopyDbClusterParameterGroupRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_DB_CLUSTER_PARAMETER_GROUP_IDENTIFIER_FIELD, TARGET_DB_CLUSTER_PARAMETER_GROUP_IDENTIFIER_FIELD, TARGET_DB_CLUSTER_PARAMETER_GROUP_DESCRIPTION_FIELD, TAGS_FIELD));
    private final String sourceDBClusterParameterGroupIdentifier;
    private final String targetDBClusterParameterGroupIdentifier;
    private final String targetDBClusterParameterGroupDescription;
    private final List<Tag> tags;

    private CopyDbClusterParameterGroupRequest(BuilderImpl builder) {
        super(builder);
        this.sourceDBClusterParameterGroupIdentifier = builder.sourceDBClusterParameterGroupIdentifier;
        this.targetDBClusterParameterGroupIdentifier = builder.targetDBClusterParameterGroupIdentifier;
        this.targetDBClusterParameterGroupDescription = builder.targetDBClusterParameterGroupDescription;
        this.tags = builder.tags;
    }

    public final String sourceDBClusterParameterGroupIdentifier() {
        return this.sourceDBClusterParameterGroupIdentifier;
    }

    public final String targetDBClusterParameterGroupIdentifier() {
        return this.targetDBClusterParameterGroupIdentifier;
    }

    public final String targetDBClusterParameterGroupDescription() {
        return this.targetDBClusterParameterGroupDescription;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDBClusterParameterGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDBClusterParameterGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDBClusterParameterGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyDbClusterParameterGroupRequest)) {
            return false;
        }
        CopyDbClusterParameterGroupRequest other = (CopyDbClusterParameterGroupRequest)((Object)obj);
        return Objects.equals(this.sourceDBClusterParameterGroupIdentifier(), other.sourceDBClusterParameterGroupIdentifier()) && Objects.equals(this.targetDBClusterParameterGroupIdentifier(), other.targetDBClusterParameterGroupIdentifier()) && Objects.equals(this.targetDBClusterParameterGroupDescription(), other.targetDBClusterParameterGroupDescription()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CopyDbClusterParameterGroupRequest").add("SourceDBClusterParameterGroupIdentifier", (Object)this.sourceDBClusterParameterGroupIdentifier()).add("TargetDBClusterParameterGroupIdentifier", (Object)this.targetDBClusterParameterGroupIdentifier()).add("TargetDBClusterParameterGroupDescription", (Object)this.targetDBClusterParameterGroupDescription()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceDBClusterParameterGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.sourceDBClusterParameterGroupIdentifier()));
            }
            case "TargetDBClusterParameterGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.targetDBClusterParameterGroupIdentifier()));
            }
            case "TargetDBClusterParameterGroupDescription": {
                return Optional.ofNullable(clazz.cast(this.targetDBClusterParameterGroupDescription()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopyDbClusterParameterGroupRequest, T> g) {
        return obj -> g.apply((CopyDbClusterParameterGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DocDbRequest.BuilderImpl
    implements Builder {
        private String sourceDBClusterParameterGroupIdentifier;
        private String targetDBClusterParameterGroupIdentifier;
        private String targetDBClusterParameterGroupDescription;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CopyDbClusterParameterGroupRequest model) {
            super(model);
            this.sourceDBClusterParameterGroupIdentifier(model.sourceDBClusterParameterGroupIdentifier);
            this.targetDBClusterParameterGroupIdentifier(model.targetDBClusterParameterGroupIdentifier);
            this.targetDBClusterParameterGroupDescription(model.targetDBClusterParameterGroupDescription);
            this.tags(model.tags);
        }

        public final String getSourceDBClusterParameterGroupIdentifier() {
            return this.sourceDBClusterParameterGroupIdentifier;
        }

        public final void setSourceDBClusterParameterGroupIdentifier(String sourceDBClusterParameterGroupIdentifier) {
            this.sourceDBClusterParameterGroupIdentifier = sourceDBClusterParameterGroupIdentifier;
        }

        @Override
        public final Builder sourceDBClusterParameterGroupIdentifier(String sourceDBClusterParameterGroupIdentifier) {
            this.sourceDBClusterParameterGroupIdentifier = sourceDBClusterParameterGroupIdentifier;
            return this;
        }

        public final String getTargetDBClusterParameterGroupIdentifier() {
            return this.targetDBClusterParameterGroupIdentifier;
        }

        public final void setTargetDBClusterParameterGroupIdentifier(String targetDBClusterParameterGroupIdentifier) {
            this.targetDBClusterParameterGroupIdentifier = targetDBClusterParameterGroupIdentifier;
        }

        @Override
        public final Builder targetDBClusterParameterGroupIdentifier(String targetDBClusterParameterGroupIdentifier) {
            this.targetDBClusterParameterGroupIdentifier = targetDBClusterParameterGroupIdentifier;
            return this;
        }

        public final String getTargetDBClusterParameterGroupDescription() {
            return this.targetDBClusterParameterGroupDescription;
        }

        public final void setTargetDBClusterParameterGroupDescription(String targetDBClusterParameterGroupDescription) {
            this.targetDBClusterParameterGroupDescription = targetDBClusterParameterGroupDescription;
        }

        @Override
        public final Builder targetDBClusterParameterGroupDescription(String targetDBClusterParameterGroupDescription) {
            this.targetDBClusterParameterGroupDescription = targetDBClusterParameterGroupDescription;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyDbClusterParameterGroupRequest build() {
            return new CopyDbClusterParameterGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DocDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CopyDbClusterParameterGroupRequest> {
        public Builder sourceDBClusterParameterGroupIdentifier(String var1);

        public Builder targetDBClusterParameterGroupIdentifier(String var1);

        public Builder targetDBClusterParameterGroupDescription(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

