/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.docdb.DocDbAsyncClient;
import software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsResponse;
import software.amazon.awssdk.services.docdb.model.OrderableDBInstanceOption;

public class DescribeOrderableDBInstanceOptionsPublisher
implements SdkPublisher<DescribeOrderableDbInstanceOptionsResponse> {
    private final DocDbAsyncClient client;
    private final DescribeOrderableDbInstanceOptionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeOrderableDBInstanceOptionsPublisher(DocDbAsyncClient client, DescribeOrderableDbInstanceOptionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeOrderableDBInstanceOptionsPublisher(DocDbAsyncClient client, DescribeOrderableDbInstanceOptionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeOrderableDbInstanceOptionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeOrderableDbInstanceOptionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OrderableDBInstanceOption> orderableDBInstanceOptions() {
        Function<DescribeOrderableDbInstanceOptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.orderableDBInstanceOptions() != null) {
                return response.orderableDBInstanceOptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeOrderableDbInstanceOptionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeOrderableDbInstanceOptionsResponseFetcher
    implements AsyncPageFetcher<DescribeOrderableDbInstanceOptionsResponse> {
        private DescribeOrderableDbInstanceOptionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOrderableDbInstanceOptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeOrderableDbInstanceOptionsResponse> nextPage(DescribeOrderableDbInstanceOptionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeOrderableDBInstanceOptionsPublisher.this.client.describeOrderableDBInstanceOptions(DescribeOrderableDBInstanceOptionsPublisher.this.firstRequest);
            }
            return DescribeOrderableDBInstanceOptionsPublisher.this.client.describeOrderableDBInstanceOptions((DescribeOrderableDbInstanceOptionsRequest)((Object)DescribeOrderableDBInstanceOptionsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

