/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DefaultDynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DefaultDynamoDbBaseClientBuilder;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClientBuilder;
import software.amazon.awssdk.services.dynamodb.DynamoDbServiceClientConfiguration;
import software.amazon.awssdk.services.dynamodb.endpoints.DynamoDbEndpointProvider;

@SdkInternalApi
final class DefaultDynamoDbAsyncClientBuilder
extends DefaultDynamoDbBaseClientBuilder<DynamoDbAsyncClientBuilder, DynamoDbAsyncClient>
implements DynamoDbAsyncClientBuilder {
    DefaultDynamoDbAsyncClientBuilder() {
    }

    @Override
    public DefaultDynamoDbAsyncClientBuilder endpointDiscoveryEnabled(boolean endpointDiscoveryEnabled) {
        this.endpointDiscoveryEnabled = endpointDiscoveryEnabled;
        return this;
    }

    @Override
    @Deprecated
    public DefaultDynamoDbAsyncClientBuilder enableEndpointDiscovery() {
        this.endpointDiscoveryEnabled = true;
        return this;
    }

    @Override
    public DefaultDynamoDbAsyncClientBuilder endpointProvider(DynamoDbEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DynamoDbAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultDynamoDbAsyncClientBuilder.validateClientOptions(clientConfiguration);
        DynamoDbServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultDynamoDbAsyncClient client = new DefaultDynamoDbAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private DynamoDbServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return DynamoDbServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

