/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.model.AttributeNameListCopier;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.services.dynamodb.model.ExpressionAttributeNameMapCopier;
import software.amazon.awssdk.services.dynamodb.model.KeyCopier;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetItemRequest
extends DynamoDbRequest
implements ToCopyableBuilder<Builder, GetItemRequest> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(GetItemRequest.getter(GetItemRequest::tableName)).setter(GetItemRequest.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<Map<String, AttributeValue>> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Key").getter(GetItemRequest.getter(GetItemRequest::key)).setter(GetItemRequest.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ATTRIBUTES_TO_GET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributesToGet").getter(GetItemRequest.getter(GetItemRequest::attributesToGet)).setter(GetItemRequest.setter(Builder::attributesToGet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributesToGet").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> CONSISTENT_READ_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ConsistentRead").getter(GetItemRequest.getter(GetItemRequest::consistentRead)).setter(GetItemRequest.setter(Builder::consistentRead)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsistentRead").build()}).build();
    private static final SdkField<String> RETURN_CONSUMED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReturnConsumedCapacity").getter(GetItemRequest.getter(GetItemRequest::returnConsumedCapacityAsString)).setter(GetItemRequest.setter(Builder::returnConsumedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnConsumedCapacity").build()}).build();
    private static final SdkField<String> PROJECTION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectionExpression").getter(GetItemRequest.getter(GetItemRequest::projectionExpression)).setter(GetItemRequest.setter(Builder::projectionExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectionExpression").build()}).build();
    private static final SdkField<Map<String, String>> EXPRESSION_ATTRIBUTE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ExpressionAttributeNames").getter(GetItemRequest.getter(GetItemRequest::expressionAttributeNames)).setter(GetItemRequest.setter(Builder::expressionAttributeNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionAttributeNames").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD, KEY_FIELD, ATTRIBUTES_TO_GET_FIELD, CONSISTENT_READ_FIELD, RETURN_CONSUMED_CAPACITY_FIELD, PROJECTION_EXPRESSION_FIELD, EXPRESSION_ATTRIBUTE_NAMES_FIELD));
    private final String tableName;
    private final Map<String, AttributeValue> key;
    private final List<String> attributesToGet;
    private final Boolean consistentRead;
    private final String returnConsumedCapacity;
    private final String projectionExpression;
    private final Map<String, String> expressionAttributeNames;

    private GetItemRequest(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.key = builder.key;
        this.attributesToGet = builder.attributesToGet;
        this.consistentRead = builder.consistentRead;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
        this.projectionExpression = builder.projectionExpression;
        this.expressionAttributeNames = builder.expressionAttributeNames;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final boolean hasKey() {
        return this.key != null && !(this.key instanceof SdkAutoConstructMap);
    }

    public final Map<String, AttributeValue> key() {
        return this.key;
    }

    public final boolean hasAttributesToGet() {
        return this.attributesToGet != null && !(this.attributesToGet instanceof SdkAutoConstructList);
    }

    public final List<String> attributesToGet() {
        return this.attributesToGet;
    }

    public final Boolean consistentRead() {
        return this.consistentRead;
    }

    public final ReturnConsumedCapacity returnConsumedCapacity() {
        return ReturnConsumedCapacity.fromValue(this.returnConsumedCapacity);
    }

    public final String returnConsumedCapacityAsString() {
        return this.returnConsumedCapacity;
    }

    public final String projectionExpression() {
        return this.projectionExpression;
    }

    public final boolean hasExpressionAttributeNames() {
        return this.expressionAttributeNames != null && !(this.expressionAttributeNames instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> expressionAttributeNames() {
        return this.expressionAttributeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKey() ? this.key() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributesToGet() ? this.attributesToGet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.consistentRead());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnConsumedCapacityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExpressionAttributeNames() ? this.expressionAttributeNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetItemRequest)) {
            return false;
        }
        GetItemRequest other = (GetItemRequest)((Object)obj);
        return Objects.equals(this.tableName(), other.tableName()) && this.hasKey() == other.hasKey() && Objects.equals(this.key(), other.key()) && this.hasAttributesToGet() == other.hasAttributesToGet() && Objects.equals(this.attributesToGet(), other.attributesToGet()) && Objects.equals(this.consistentRead(), other.consistentRead()) && Objects.equals(this.returnConsumedCapacityAsString(), other.returnConsumedCapacityAsString()) && Objects.equals(this.projectionExpression(), other.projectionExpression()) && this.hasExpressionAttributeNames() == other.hasExpressionAttributeNames() && Objects.equals(this.expressionAttributeNames(), other.expressionAttributeNames());
    }

    public final String toString() {
        return ToString.builder((String)"GetItemRequest").add("TableName", (Object)this.tableName()).add("Key", this.hasKey() ? this.key() : null).add("AttributesToGet", this.hasAttributesToGet() ? this.attributesToGet() : null).add("ConsistentRead", (Object)this.consistentRead()).add("ReturnConsumedCapacity", (Object)this.returnConsumedCapacityAsString()).add("ProjectionExpression", (Object)this.projectionExpression()).add("ExpressionAttributeNames", this.hasExpressionAttributeNames() ? this.expressionAttributeNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "AttributesToGet": {
                return Optional.ofNullable(clazz.cast(this.attributesToGet()));
            }
            case "ConsistentRead": {
                return Optional.ofNullable(clazz.cast(this.consistentRead()));
            }
            case "ReturnConsumedCapacity": {
                return Optional.ofNullable(clazz.cast(this.returnConsumedCapacityAsString()));
            }
            case "ProjectionExpression": {
                return Optional.ofNullable(clazz.cast(this.projectionExpression()));
            }
            case "ExpressionAttributeNames": {
                return Optional.ofNullable(clazz.cast(this.expressionAttributeNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetItemRequest, T> g) {
        return obj -> g.apply((GetItemRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbRequest.BuilderImpl
    implements Builder {
        private String tableName;
        private Map<String, AttributeValue> key = DefaultSdkAutoConstructMap.getInstance();
        private List<String> attributesToGet = DefaultSdkAutoConstructList.getInstance();
        private Boolean consistentRead;
        private String returnConsumedCapacity;
        private String projectionExpression;
        private Map<String, String> expressionAttributeNames = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetItemRequest model) {
            super(model);
            this.tableName(model.tableName);
            this.key(model.key);
            this.attributesToGet(model.attributesToGet);
            this.consistentRead(model.consistentRead);
            this.returnConsumedCapacity(model.returnConsumedCapacity);
            this.projectionExpression(model.projectionExpression);
            this.expressionAttributeNames(model.expressionAttributeNames);
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final Map<String, AttributeValue.Builder> getKey() {
            Map<String, AttributeValue.Builder> result = KeyCopier.copyToBuilder(this.key);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setKey(Map<String, AttributeValue.BuilderImpl> key) {
            this.key = KeyCopier.copyFromBuilder(key);
        }

        @Override
        public final Builder key(Map<String, AttributeValue> key) {
            this.key = KeyCopier.copy(key);
            return this;
        }

        public final Collection<String> getAttributesToGet() {
            if (this.attributesToGet instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributesToGet;
        }

        public final void setAttributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = AttributeNameListCopier.copy(attributesToGet);
        }

        @Override
        public final Builder attributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = AttributeNameListCopier.copy(attributesToGet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToGet(String ... attributesToGet) {
            this.attributesToGet(Arrays.asList(attributesToGet));
            return this;
        }

        public final Boolean getConsistentRead() {
            return this.consistentRead;
        }

        public final void setConsistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
        }

        @Override
        public final Builder consistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
            return this;
        }

        public final String getReturnConsumedCapacity() {
            return this.returnConsumedCapacity;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        @Override
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity == null ? null : returnConsumedCapacity.toString());
            return this;
        }

        public final String getProjectionExpression() {
            return this.projectionExpression;
        }

        public final void setProjectionExpression(String projectionExpression) {
            this.projectionExpression = projectionExpression;
        }

        @Override
        public final Builder projectionExpression(String projectionExpression) {
            this.projectionExpression = projectionExpression;
            return this;
        }

        public final Map<String, String> getExpressionAttributeNames() {
            if (this.expressionAttributeNames instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.expressionAttributeNames;
        }

        public final void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
        }

        @Override
        public final Builder expressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetItemRequest build() {
            return new GetItemRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DynamoDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetItemRequest> {
        public Builder tableName(String var1);

        public Builder key(Map<String, AttributeValue> var1);

        public Builder attributesToGet(Collection<String> var1);

        public Builder attributesToGet(String ... var1);

        public Builder consistentRead(Boolean var1);

        public Builder returnConsumedCapacity(String var1);

        public Builder returnConsumedCapacity(ReturnConsumedCapacity var1);

        public Builder projectionExpression(String var1);

        public Builder expressionAttributeNames(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

