/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.forecast.ForecastAsyncClient;
import software.amazon.awssdk.services.forecast.internal.UserAgentUtils;
import software.amazon.awssdk.services.forecast.model.DatasetImportJobSummary;
import software.amazon.awssdk.services.forecast.model.ListDatasetImportJobsRequest;
import software.amazon.awssdk.services.forecast.model.ListDatasetImportJobsResponse;

public class ListDatasetImportJobsPublisher
implements SdkPublisher<ListDatasetImportJobsResponse> {
    private final ForecastAsyncClient client;
    private final ListDatasetImportJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDatasetImportJobsPublisher(ForecastAsyncClient client, ListDatasetImportJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDatasetImportJobsPublisher(ForecastAsyncClient client, ListDatasetImportJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDatasetImportJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDatasetImportJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DatasetImportJobSummary> datasetImportJobs() {
        Function<ListDatasetImportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.datasetImportJobs() != null) {
                return response.datasetImportJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDatasetImportJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDatasetImportJobsResponseFetcher
    implements AsyncPageFetcher<ListDatasetImportJobsResponse> {
        private ListDatasetImportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListDatasetImportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDatasetImportJobsResponse> nextPage(ListDatasetImportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListDatasetImportJobsPublisher.this.client.listDatasetImportJobs(ListDatasetImportJobsPublisher.this.firstRequest);
            }
            return ListDatasetImportJobsPublisher.this.client.listDatasetImportJobs((ListDatasetImportJobsRequest)((Object)ListDatasetImportJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

