/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteContainerRecipeResponse
extends ImagebuilderResponse
implements ToCopyableBuilder<Builder, DeleteContainerRecipeResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestId").getter(DeleteContainerRecipeResponse.getter(DeleteContainerRecipeResponse::requestId)).setter(DeleteContainerRecipeResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()}).build();
    private static final SdkField<String> CONTAINER_RECIPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerRecipeArn").getter(DeleteContainerRecipeResponse.getter(DeleteContainerRecipeResponse::containerRecipeArn)).setter(DeleteContainerRecipeResponse.setter(Builder::containerRecipeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerRecipeArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, CONTAINER_RECIPE_ARN_FIELD));
    private final String requestIdValue;
    private final String containerRecipeArn;

    private DeleteContainerRecipeResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.containerRecipeArn = builder.containerRecipeArn;
    }

    public final String requestId() {
        return this.requestIdValue;
    }

    public final String containerRecipeArn() {
        return this.containerRecipeArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerRecipeArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteContainerRecipeResponse)) {
            return false;
        }
        DeleteContainerRecipeResponse other = (DeleteContainerRecipeResponse)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.containerRecipeArn(), other.containerRecipeArn());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteContainerRecipeResponse").add("RequestId", (Object)this.requestId()).add("ContainerRecipeArn", (Object)this.containerRecipeArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "containerRecipeArn": {
                return Optional.ofNullable(clazz.cast(this.containerRecipeArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteContainerRecipeResponse, T> g) {
        return obj -> g.apply((DeleteContainerRecipeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderResponse.BuilderImpl
    implements Builder {
        private String requestIdValue;
        private String containerRecipeArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteContainerRecipeResponse model) {
            super(model);
            this.requestId(model.requestIdValue);
            this.containerRecipeArn(model.containerRecipeArn);
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final String getContainerRecipeArn() {
            return this.containerRecipeArn;
        }

        public final void setContainerRecipeArn(String containerRecipeArn) {
            this.containerRecipeArn = containerRecipeArn;
        }

        @Override
        public final Builder containerRecipeArn(String containerRecipeArn) {
            this.containerRecipeArn = containerRecipeArn;
            return this;
        }

        @Override
        public DeleteContainerRecipeResponse build() {
            return new DeleteContainerRecipeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ImagebuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteContainerRecipeResponse> {
        public Builder requestId(String var1);

        public Builder containerRecipeArn(String var1);
    }
}

