/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ImageScanStatus {
    PENDING("PENDING"),
    SCANNING("SCANNING"),
    COLLECTING("COLLECTING"),
    COMPLETED("COMPLETED"),
    ABANDONED("ABANDONED"),
    FAILED("FAILED"),
    TIMED_OUT("TIMED_OUT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ImageScanStatus> VALUE_MAP;
    private final String value;

    private ImageScanStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImageScanStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImageScanStatus> knownValues() {
        EnumSet<ImageScanStatus> knownValues = EnumSet.allOf(ImageScanStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ImageScanStatus.class, ImageScanStatus::toString);
    }
}

