/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.m2.M2Client;
import software.amazon.awssdk.services.m2.model.EngineVersionsSummary;
import software.amazon.awssdk.services.m2.model.ListEngineVersionsRequest;
import software.amazon.awssdk.services.m2.model.ListEngineVersionsResponse;

public class ListEngineVersionsIterable
implements SdkIterable<ListEngineVersionsResponse> {
    private final M2Client client;
    private final ListEngineVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEngineVersionsIterable(M2Client client, ListEngineVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEngineVersionsResponseFetcher();
    }

    public Iterator<ListEngineVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EngineVersionsSummary> engineVersions() {
        Function<ListEngineVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.engineVersions() != null) {
                return response.engineVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEngineVersionsResponseFetcher
    implements SyncPageFetcher<ListEngineVersionsResponse> {
        private ListEngineVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListEngineVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEngineVersionsResponse nextPage(ListEngineVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListEngineVersionsIterable.this.client.listEngineVersions(ListEngineVersionsIterable.this.firstRequest);
            }
            return ListEngineVersionsIterable.this.client.listEngineVersions((ListEngineVersionsRequest)((Object)ListEngineVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

