/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RouteTableType {
    TRANSIT_GATEWAY_ROUTE_TABLE("TRANSIT_GATEWAY_ROUTE_TABLE"),
    CORE_NETWORK_SEGMENT("CORE_NETWORK_SEGMENT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RouteTableType> VALUE_MAP;
    private final String value;

    private RouteTableType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RouteTableType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RouteTableType> knownValues() {
        EnumSet<RouteTableType> knownValues = EnumSet.allOf(RouteTableType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RouteTableType.class, RouteTableType::toString);
    }
}

