/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2AsyncClient;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SpendLimit;

public class DescribeSpendLimitsPublisher
implements SdkPublisher<DescribeSpendLimitsResponse> {
    private final PinpointSmsVoiceV2AsyncClient client;
    private final DescribeSpendLimitsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSpendLimitsPublisher(PinpointSmsVoiceV2AsyncClient client, DescribeSpendLimitsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSpendLimitsPublisher(PinpointSmsVoiceV2AsyncClient client, DescribeSpendLimitsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeSpendLimitsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeSpendLimitsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SpendLimit> spendLimits() {
        Function<DescribeSpendLimitsResponse, Iterator> getIterator = response -> {
            if (response != null && response.spendLimits() != null) {
                return response.spendLimits().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeSpendLimitsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeSpendLimitsResponseFetcher
    implements AsyncPageFetcher<DescribeSpendLimitsResponse> {
        private DescribeSpendLimitsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSpendLimitsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeSpendLimitsResponse> nextPage(DescribeSpendLimitsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSpendLimitsPublisher.this.client.describeSpendLimits(DescribeSpendLimitsPublisher.this.firstRequest);
            }
            return DescribeSpendLimitsPublisher.this.client.describeSpendLimits((DescribeSpendLimitsRequest)((Object)DescribeSpendLimitsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

