/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.FieldSortOptions;
import software.amazon.awssdk.services.quicksight.model.FieldSortOptionsListCopier;
import software.amazon.awssdk.services.quicksight.model.ItemsLimitConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BarChartSortConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BarChartSortConfiguration> {
    private static final SdkField<List<FieldSortOptions>> CATEGORY_SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CategorySort").getter(BarChartSortConfiguration.getter(BarChartSortConfiguration::categorySort)).setter(BarChartSortConfiguration.setter(Builder::categorySort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategorySort").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldSortOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ItemsLimitConfiguration> CATEGORY_ITEMS_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CategoryItemsLimit").getter(BarChartSortConfiguration.getter(BarChartSortConfiguration::categoryItemsLimit)).setter(BarChartSortConfiguration.setter(Builder::categoryItemsLimit)).constructor(ItemsLimitConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryItemsLimit").build()}).build();
    private static final SdkField<List<FieldSortOptions>> COLOR_SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColorSort").getter(BarChartSortConfiguration.getter(BarChartSortConfiguration::colorSort)).setter(BarChartSortConfiguration.setter(Builder::colorSort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColorSort").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldSortOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ItemsLimitConfiguration> COLOR_ITEMS_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ColorItemsLimit").getter(BarChartSortConfiguration.getter(BarChartSortConfiguration::colorItemsLimit)).setter(BarChartSortConfiguration.setter(Builder::colorItemsLimit)).constructor(ItemsLimitConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColorItemsLimit").build()}).build();
    private static final SdkField<List<FieldSortOptions>> SMALL_MULTIPLES_SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SmallMultiplesSort").getter(BarChartSortConfiguration.getter(BarChartSortConfiguration::smallMultiplesSort)).setter(BarChartSortConfiguration.setter(Builder::smallMultiplesSort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmallMultiplesSort").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldSortOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ItemsLimitConfiguration> SMALL_MULTIPLES_LIMIT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SmallMultiplesLimitConfiguration").getter(BarChartSortConfiguration.getter(BarChartSortConfiguration::smallMultiplesLimitConfiguration)).setter(BarChartSortConfiguration.setter(Builder::smallMultiplesLimitConfiguration)).constructor(ItemsLimitConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmallMultiplesLimitConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_SORT_FIELD, CATEGORY_ITEMS_LIMIT_FIELD, COLOR_SORT_FIELD, COLOR_ITEMS_LIMIT_FIELD, SMALL_MULTIPLES_SORT_FIELD, SMALL_MULTIPLES_LIMIT_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<FieldSortOptions> categorySort;
    private final ItemsLimitConfiguration categoryItemsLimit;
    private final List<FieldSortOptions> colorSort;
    private final ItemsLimitConfiguration colorItemsLimit;
    private final List<FieldSortOptions> smallMultiplesSort;
    private final ItemsLimitConfiguration smallMultiplesLimitConfiguration;

    private BarChartSortConfiguration(BuilderImpl builder) {
        this.categorySort = builder.categorySort;
        this.categoryItemsLimit = builder.categoryItemsLimit;
        this.colorSort = builder.colorSort;
        this.colorItemsLimit = builder.colorItemsLimit;
        this.smallMultiplesSort = builder.smallMultiplesSort;
        this.smallMultiplesLimitConfiguration = builder.smallMultiplesLimitConfiguration;
    }

    public final boolean hasCategorySort() {
        return this.categorySort != null && !(this.categorySort instanceof SdkAutoConstructList);
    }

    public final List<FieldSortOptions> categorySort() {
        return this.categorySort;
    }

    public final ItemsLimitConfiguration categoryItemsLimit() {
        return this.categoryItemsLimit;
    }

    public final boolean hasColorSort() {
        return this.colorSort != null && !(this.colorSort instanceof SdkAutoConstructList);
    }

    public final List<FieldSortOptions> colorSort() {
        return this.colorSort;
    }

    public final ItemsLimitConfiguration colorItemsLimit() {
        return this.colorItemsLimit;
    }

    public final boolean hasSmallMultiplesSort() {
        return this.smallMultiplesSort != null && !(this.smallMultiplesSort instanceof SdkAutoConstructList);
    }

    public final List<FieldSortOptions> smallMultiplesSort() {
        return this.smallMultiplesSort;
    }

    public final ItemsLimitConfiguration smallMultiplesLimitConfiguration() {
        return this.smallMultiplesLimitConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCategorySort() ? this.categorySort() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryItemsLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColorSort() ? this.colorSort() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.colorItemsLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSmallMultiplesSort() ? this.smallMultiplesSort() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.smallMultiplesLimitConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BarChartSortConfiguration)) {
            return false;
        }
        BarChartSortConfiguration other = (BarChartSortConfiguration)obj;
        return this.hasCategorySort() == other.hasCategorySort() && Objects.equals(this.categorySort(), other.categorySort()) && Objects.equals(this.categoryItemsLimit(), other.categoryItemsLimit()) && this.hasColorSort() == other.hasColorSort() && Objects.equals(this.colorSort(), other.colorSort()) && Objects.equals(this.colorItemsLimit(), other.colorItemsLimit()) && this.hasSmallMultiplesSort() == other.hasSmallMultiplesSort() && Objects.equals(this.smallMultiplesSort(), other.smallMultiplesSort()) && Objects.equals(this.smallMultiplesLimitConfiguration(), other.smallMultiplesLimitConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"BarChartSortConfiguration").add("CategorySort", this.hasCategorySort() ? this.categorySort() : null).add("CategoryItemsLimit", (Object)this.categoryItemsLimit()).add("ColorSort", this.hasColorSort() ? this.colorSort() : null).add("ColorItemsLimit", (Object)this.colorItemsLimit()).add("SmallMultiplesSort", this.hasSmallMultiplesSort() ? this.smallMultiplesSort() : null).add("SmallMultiplesLimitConfiguration", (Object)this.smallMultiplesLimitConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CategorySort": {
                return Optional.ofNullable(clazz.cast(this.categorySort()));
            }
            case "CategoryItemsLimit": {
                return Optional.ofNullable(clazz.cast(this.categoryItemsLimit()));
            }
            case "ColorSort": {
                return Optional.ofNullable(clazz.cast(this.colorSort()));
            }
            case "ColorItemsLimit": {
                return Optional.ofNullable(clazz.cast(this.colorItemsLimit()));
            }
            case "SmallMultiplesSort": {
                return Optional.ofNullable(clazz.cast(this.smallMultiplesSort()));
            }
            case "SmallMultiplesLimitConfiguration": {
                return Optional.ofNullable(clazz.cast(this.smallMultiplesLimitConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BarChartSortConfiguration, T> g) {
        return obj -> g.apply((BarChartSortConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<FieldSortOptions> categorySort = DefaultSdkAutoConstructList.getInstance();
        private ItemsLimitConfiguration categoryItemsLimit;
        private List<FieldSortOptions> colorSort = DefaultSdkAutoConstructList.getInstance();
        private ItemsLimitConfiguration colorItemsLimit;
        private List<FieldSortOptions> smallMultiplesSort = DefaultSdkAutoConstructList.getInstance();
        private ItemsLimitConfiguration smallMultiplesLimitConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(BarChartSortConfiguration model) {
            this.categorySort(model.categorySort);
            this.categoryItemsLimit(model.categoryItemsLimit);
            this.colorSort(model.colorSort);
            this.colorItemsLimit(model.colorItemsLimit);
            this.smallMultiplesSort(model.smallMultiplesSort);
            this.smallMultiplesLimitConfiguration(model.smallMultiplesLimitConfiguration);
        }

        public final List<FieldSortOptions.Builder> getCategorySort() {
            List<FieldSortOptions.Builder> result = FieldSortOptionsListCopier.copyToBuilder(this.categorySort);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategorySort(Collection<FieldSortOptions.BuilderImpl> categorySort) {
            this.categorySort = FieldSortOptionsListCopier.copyFromBuilder(categorySort);
        }

        @Override
        public final Builder categorySort(Collection<FieldSortOptions> categorySort) {
            this.categorySort = FieldSortOptionsListCopier.copy(categorySort);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categorySort(FieldSortOptions ... categorySort) {
            this.categorySort(Arrays.asList(categorySort));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categorySort(Consumer<FieldSortOptions.Builder> ... categorySort) {
            this.categorySort(Stream.of(categorySort).map(c -> (FieldSortOptions)((FieldSortOptions.Builder)FieldSortOptions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ItemsLimitConfiguration.Builder getCategoryItemsLimit() {
            return this.categoryItemsLimit != null ? this.categoryItemsLimit.toBuilder() : null;
        }

        public final void setCategoryItemsLimit(ItemsLimitConfiguration.BuilderImpl categoryItemsLimit) {
            this.categoryItemsLimit = categoryItemsLimit != null ? categoryItemsLimit.build() : null;
        }

        @Override
        public final Builder categoryItemsLimit(ItemsLimitConfiguration categoryItemsLimit) {
            this.categoryItemsLimit = categoryItemsLimit;
            return this;
        }

        public final List<FieldSortOptions.Builder> getColorSort() {
            List<FieldSortOptions.Builder> result = FieldSortOptionsListCopier.copyToBuilder(this.colorSort);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColorSort(Collection<FieldSortOptions.BuilderImpl> colorSort) {
            this.colorSort = FieldSortOptionsListCopier.copyFromBuilder(colorSort);
        }

        @Override
        public final Builder colorSort(Collection<FieldSortOptions> colorSort) {
            this.colorSort = FieldSortOptionsListCopier.copy(colorSort);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder colorSort(FieldSortOptions ... colorSort) {
            this.colorSort(Arrays.asList(colorSort));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder colorSort(Consumer<FieldSortOptions.Builder> ... colorSort) {
            this.colorSort(Stream.of(colorSort).map(c -> (FieldSortOptions)((FieldSortOptions.Builder)FieldSortOptions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ItemsLimitConfiguration.Builder getColorItemsLimit() {
            return this.colorItemsLimit != null ? this.colorItemsLimit.toBuilder() : null;
        }

        public final void setColorItemsLimit(ItemsLimitConfiguration.BuilderImpl colorItemsLimit) {
            this.colorItemsLimit = colorItemsLimit != null ? colorItemsLimit.build() : null;
        }

        @Override
        public final Builder colorItemsLimit(ItemsLimitConfiguration colorItemsLimit) {
            this.colorItemsLimit = colorItemsLimit;
            return this;
        }

        public final List<FieldSortOptions.Builder> getSmallMultiplesSort() {
            List<FieldSortOptions.Builder> result = FieldSortOptionsListCopier.copyToBuilder(this.smallMultiplesSort);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSmallMultiplesSort(Collection<FieldSortOptions.BuilderImpl> smallMultiplesSort) {
            this.smallMultiplesSort = FieldSortOptionsListCopier.copyFromBuilder(smallMultiplesSort);
        }

        @Override
        public final Builder smallMultiplesSort(Collection<FieldSortOptions> smallMultiplesSort) {
            this.smallMultiplesSort = FieldSortOptionsListCopier.copy(smallMultiplesSort);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder smallMultiplesSort(FieldSortOptions ... smallMultiplesSort) {
            this.smallMultiplesSort(Arrays.asList(smallMultiplesSort));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder smallMultiplesSort(Consumer<FieldSortOptions.Builder> ... smallMultiplesSort) {
            this.smallMultiplesSort(Stream.of(smallMultiplesSort).map(c -> (FieldSortOptions)((FieldSortOptions.Builder)FieldSortOptions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ItemsLimitConfiguration.Builder getSmallMultiplesLimitConfiguration() {
            return this.smallMultiplesLimitConfiguration != null ? this.smallMultiplesLimitConfiguration.toBuilder() : null;
        }

        public final void setSmallMultiplesLimitConfiguration(ItemsLimitConfiguration.BuilderImpl smallMultiplesLimitConfiguration) {
            this.smallMultiplesLimitConfiguration = smallMultiplesLimitConfiguration != null ? smallMultiplesLimitConfiguration.build() : null;
        }

        @Override
        public final Builder smallMultiplesLimitConfiguration(ItemsLimitConfiguration smallMultiplesLimitConfiguration) {
            this.smallMultiplesLimitConfiguration = smallMultiplesLimitConfiguration;
            return this;
        }

        public BarChartSortConfiguration build() {
            return new BarChartSortConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BarChartSortConfiguration> {
        public Builder categorySort(Collection<FieldSortOptions> var1);

        public Builder categorySort(FieldSortOptions ... var1);

        public Builder categorySort(Consumer<FieldSortOptions.Builder> ... var1);

        public Builder categoryItemsLimit(ItemsLimitConfiguration var1);

        default public Builder categoryItemsLimit(Consumer<ItemsLimitConfiguration.Builder> categoryItemsLimit) {
            return this.categoryItemsLimit((ItemsLimitConfiguration)((ItemsLimitConfiguration.Builder)ItemsLimitConfiguration.builder().applyMutation(categoryItemsLimit)).build());
        }

        public Builder colorSort(Collection<FieldSortOptions> var1);

        public Builder colorSort(FieldSortOptions ... var1);

        public Builder colorSort(Consumer<FieldSortOptions.Builder> ... var1);

        public Builder colorItemsLimit(ItemsLimitConfiguration var1);

        default public Builder colorItemsLimit(Consumer<ItemsLimitConfiguration.Builder> colorItemsLimit) {
            return this.colorItemsLimit((ItemsLimitConfiguration)((ItemsLimitConfiguration.Builder)ItemsLimitConfiguration.builder().applyMutation(colorItemsLimit)).build());
        }

        public Builder smallMultiplesSort(Collection<FieldSortOptions> var1);

        public Builder smallMultiplesSort(FieldSortOptions ... var1);

        public Builder smallMultiplesSort(Consumer<FieldSortOptions.Builder> ... var1);

        public Builder smallMultiplesLimitConfiguration(ItemsLimitConfiguration var1);

        default public Builder smallMultiplesLimitConfiguration(Consumer<ItemsLimitConfiguration.Builder> smallMultiplesLimitConfiguration) {
            return this.smallMultiplesLimitConfiguration((ItemsLimitConfiguration)((ItemsLimitConfiguration.Builder)ItemsLimitConfiguration.builder().applyMutation(smallMultiplesLimitConfiguration)).build());
        }
    }
}

