/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.IngestionType;
import software.amazon.awssdk.services.quicksight.model.RefreshFrequency;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RefreshSchedule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RefreshSchedule> {
    private static final SdkField<String> SCHEDULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleId").getter(RefreshSchedule.getter(RefreshSchedule::scheduleId)).setter(RefreshSchedule.setter(Builder::scheduleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleId").build()}).build();
    private static final SdkField<RefreshFrequency> SCHEDULE_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScheduleFrequency").getter(RefreshSchedule.getter(RefreshSchedule::scheduleFrequency)).setter(RefreshSchedule.setter(Builder::scheduleFrequency)).constructor(RefreshFrequency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleFrequency").build()}).build();
    private static final SdkField<Instant> START_AFTER_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartAfterDateTime").getter(RefreshSchedule.getter(RefreshSchedule::startAfterDateTime)).setter(RefreshSchedule.setter(Builder::startAfterDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartAfterDateTime").build()}).build();
    private static final SdkField<String> REFRESH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RefreshType").getter(RefreshSchedule.getter(RefreshSchedule::refreshTypeAsString)).setter(RefreshSchedule.setter(Builder::refreshType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshType").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(RefreshSchedule.getter(RefreshSchedule::arn)).setter(RefreshSchedule.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_ID_FIELD, SCHEDULE_FREQUENCY_FIELD, START_AFTER_DATE_TIME_FIELD, REFRESH_TYPE_FIELD, ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String scheduleId;
    private final RefreshFrequency scheduleFrequency;
    private final Instant startAfterDateTime;
    private final String refreshType;
    private final String arn;

    private RefreshSchedule(BuilderImpl builder) {
        this.scheduleId = builder.scheduleId;
        this.scheduleFrequency = builder.scheduleFrequency;
        this.startAfterDateTime = builder.startAfterDateTime;
        this.refreshType = builder.refreshType;
        this.arn = builder.arn;
    }

    public final String scheduleId() {
        return this.scheduleId;
    }

    public final RefreshFrequency scheduleFrequency() {
        return this.scheduleFrequency;
    }

    public final Instant startAfterDateTime() {
        return this.startAfterDateTime;
    }

    public final IngestionType refreshType() {
        return IngestionType.fromValue(this.refreshType);
    }

    public final String refreshTypeAsString() {
        return this.refreshType;
    }

    public final String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.startAfterDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefreshSchedule)) {
            return false;
        }
        RefreshSchedule other = (RefreshSchedule)obj;
        return Objects.equals(this.scheduleId(), other.scheduleId()) && Objects.equals(this.scheduleFrequency(), other.scheduleFrequency()) && Objects.equals(this.startAfterDateTime(), other.startAfterDateTime()) && Objects.equals(this.refreshTypeAsString(), other.refreshTypeAsString()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"RefreshSchedule").add("ScheduleId", (Object)this.scheduleId()).add("ScheduleFrequency", (Object)this.scheduleFrequency()).add("StartAfterDateTime", (Object)this.startAfterDateTime()).add("RefreshType", (Object)this.refreshTypeAsString()).add("Arn", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScheduleId": {
                return Optional.ofNullable(clazz.cast(this.scheduleId()));
            }
            case "ScheduleFrequency": {
                return Optional.ofNullable(clazz.cast(this.scheduleFrequency()));
            }
            case "StartAfterDateTime": {
                return Optional.ofNullable(clazz.cast(this.startAfterDateTime()));
            }
            case "RefreshType": {
                return Optional.ofNullable(clazz.cast(this.refreshTypeAsString()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RefreshSchedule, T> g) {
        return obj -> g.apply((RefreshSchedule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scheduleId;
        private RefreshFrequency scheduleFrequency;
        private Instant startAfterDateTime;
        private String refreshType;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(RefreshSchedule model) {
            this.scheduleId(model.scheduleId);
            this.scheduleFrequency(model.scheduleFrequency);
            this.startAfterDateTime(model.startAfterDateTime);
            this.refreshType(model.refreshType);
            this.arn(model.arn);
        }

        public final String getScheduleId() {
            return this.scheduleId;
        }

        public final void setScheduleId(String scheduleId) {
            this.scheduleId = scheduleId;
        }

        @Override
        public final Builder scheduleId(String scheduleId) {
            this.scheduleId = scheduleId;
            return this;
        }

        public final RefreshFrequency.Builder getScheduleFrequency() {
            return this.scheduleFrequency != null ? this.scheduleFrequency.toBuilder() : null;
        }

        public final void setScheduleFrequency(RefreshFrequency.BuilderImpl scheduleFrequency) {
            this.scheduleFrequency = scheduleFrequency != null ? scheduleFrequency.build() : null;
        }

        @Override
        public final Builder scheduleFrequency(RefreshFrequency scheduleFrequency) {
            this.scheduleFrequency = scheduleFrequency;
            return this;
        }

        public final Instant getStartAfterDateTime() {
            return this.startAfterDateTime;
        }

        public final void setStartAfterDateTime(Instant startAfterDateTime) {
            this.startAfterDateTime = startAfterDateTime;
        }

        @Override
        public final Builder startAfterDateTime(Instant startAfterDateTime) {
            this.startAfterDateTime = startAfterDateTime;
            return this;
        }

        public final String getRefreshType() {
            return this.refreshType;
        }

        public final void setRefreshType(String refreshType) {
            this.refreshType = refreshType;
        }

        @Override
        public final Builder refreshType(String refreshType) {
            this.refreshType = refreshType;
            return this;
        }

        @Override
        public final Builder refreshType(IngestionType refreshType) {
            this.refreshType(refreshType == null ? null : refreshType.toString());
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public RefreshSchedule build() {
            return new RefreshSchedule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RefreshSchedule> {
        public Builder scheduleId(String var1);

        public Builder scheduleFrequency(RefreshFrequency var1);

        default public Builder scheduleFrequency(Consumer<RefreshFrequency.Builder> scheduleFrequency) {
            return this.scheduleFrequency((RefreshFrequency)((RefreshFrequency.Builder)RefreshFrequency.builder().applyMutation(scheduleFrequency)).build());
        }

        public Builder startAfterDateTime(Instant var1);

        public Builder refreshType(String var1);

        public Builder refreshType(IngestionType var1);

        public Builder arn(String var1);
    }
}

