/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.RollingDateConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimeRangeFilterValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimeRangeFilterValue> {
    private static final SdkField<Instant> STATIC_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StaticValue").getter(TimeRangeFilterValue.getter(TimeRangeFilterValue::staticValue)).setter(TimeRangeFilterValue.setter(Builder::staticValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticValue").build()}).build();
    private static final SdkField<RollingDateConfiguration> ROLLING_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RollingDate").getter(TimeRangeFilterValue.getter(TimeRangeFilterValue::rollingDate)).setter(TimeRangeFilterValue.setter(Builder::rollingDate)).constructor(RollingDateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollingDate").build()}).build();
    private static final SdkField<String> PARAMETER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Parameter").getter(TimeRangeFilterValue.getter(TimeRangeFilterValue::parameter)).setter(TimeRangeFilterValue.setter(Builder::parameter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATIC_VALUE_FIELD, ROLLING_DATE_FIELD, PARAMETER_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant staticValue;
    private final RollingDateConfiguration rollingDate;
    private final String parameter;

    private TimeRangeFilterValue(BuilderImpl builder) {
        this.staticValue = builder.staticValue;
        this.rollingDate = builder.rollingDate;
        this.parameter = builder.parameter;
    }

    public final Instant staticValue() {
        return this.staticValue;
    }

    public final RollingDateConfiguration rollingDate() {
        return this.rollingDate;
    }

    public final String parameter() {
        return this.parameter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.staticValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.rollingDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeRangeFilterValue)) {
            return false;
        }
        TimeRangeFilterValue other = (TimeRangeFilterValue)obj;
        return Objects.equals(this.staticValue(), other.staticValue()) && Objects.equals(this.rollingDate(), other.rollingDate()) && Objects.equals(this.parameter(), other.parameter());
    }

    public final String toString() {
        return ToString.builder((String)"TimeRangeFilterValue").add("StaticValue", (Object)this.staticValue()).add("RollingDate", (Object)this.rollingDate()).add("Parameter", (Object)this.parameter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StaticValue": {
                return Optional.ofNullable(clazz.cast(this.staticValue()));
            }
            case "RollingDate": {
                return Optional.ofNullable(clazz.cast(this.rollingDate()));
            }
            case "Parameter": {
                return Optional.ofNullable(clazz.cast(this.parameter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimeRangeFilterValue, T> g) {
        return obj -> g.apply((TimeRangeFilterValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant staticValue;
        private RollingDateConfiguration rollingDate;
        private String parameter;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeRangeFilterValue model) {
            this.staticValue(model.staticValue);
            this.rollingDate(model.rollingDate);
            this.parameter(model.parameter);
        }

        public final Instant getStaticValue() {
            return this.staticValue;
        }

        public final void setStaticValue(Instant staticValue) {
            this.staticValue = staticValue;
        }

        @Override
        public final Builder staticValue(Instant staticValue) {
            this.staticValue = staticValue;
            return this;
        }

        public final RollingDateConfiguration.Builder getRollingDate() {
            return this.rollingDate != null ? this.rollingDate.toBuilder() : null;
        }

        public final void setRollingDate(RollingDateConfiguration.BuilderImpl rollingDate) {
            this.rollingDate = rollingDate != null ? rollingDate.build() : null;
        }

        @Override
        public final Builder rollingDate(RollingDateConfiguration rollingDate) {
            this.rollingDate = rollingDate;
            return this;
        }

        public final String getParameter() {
            return this.parameter;
        }

        public final void setParameter(String parameter) {
            this.parameter = parameter;
        }

        @Override
        public final Builder parameter(String parameter) {
            this.parameter = parameter;
            return this;
        }

        public TimeRangeFilterValue build() {
            return new TimeRangeFilterValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimeRangeFilterValue> {
        public Builder staticValue(Instant var1);

        public Builder rollingDate(RollingDateConfiguration var1);

        default public Builder rollingDate(Consumer<RollingDateConfiguration.Builder> rollingDate) {
            return this.rollingDate((RollingDateConfiguration)((RollingDateConfiguration.Builder)RollingDateConfiguration.builder().applyMutation(rollingDate)).build());
        }

        public Builder parameter(String var1);
    }
}

