/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.CategoryFilterFunction;
import software.amazon.awssdk.services.quicksight.model.CategoryFilterType;
import software.amazon.awssdk.services.quicksight.model.TopicCategoryFilterConstant;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicCategoryFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopicCategoryFilter> {
    private static final SdkField<String> CATEGORY_FILTER_FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CategoryFilterFunction").getter(TopicCategoryFilter.getter(TopicCategoryFilter::categoryFilterFunctionAsString)).setter(TopicCategoryFilter.setter(Builder::categoryFilterFunction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryFilterFunction").build()}).build();
    private static final SdkField<String> CATEGORY_FILTER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CategoryFilterType").getter(TopicCategoryFilter.getter(TopicCategoryFilter::categoryFilterTypeAsString)).setter(TopicCategoryFilter.setter(Builder::categoryFilterType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryFilterType").build()}).build();
    private static final SdkField<TopicCategoryFilterConstant> CONSTANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Constant").getter(TopicCategoryFilter.getter(TopicCategoryFilter::constant)).setter(TopicCategoryFilter.setter(Builder::constant)).constructor(TopicCategoryFilterConstant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Constant").build()}).build();
    private static final SdkField<Boolean> INVERSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Inverse").getter(TopicCategoryFilter.getter(TopicCategoryFilter::inverse)).setter(TopicCategoryFilter.setter(Builder::inverse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inverse").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FILTER_FUNCTION_FIELD, CATEGORY_FILTER_TYPE_FIELD, CONSTANT_FIELD, INVERSE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String categoryFilterFunction;
    private final String categoryFilterType;
    private final TopicCategoryFilterConstant constant;
    private final Boolean inverse;

    private TopicCategoryFilter(BuilderImpl builder) {
        this.categoryFilterFunction = builder.categoryFilterFunction;
        this.categoryFilterType = builder.categoryFilterType;
        this.constant = builder.constant;
        this.inverse = builder.inverse;
    }

    public final CategoryFilterFunction categoryFilterFunction() {
        return CategoryFilterFunction.fromValue(this.categoryFilterFunction);
    }

    public final String categoryFilterFunctionAsString() {
        return this.categoryFilterFunction;
    }

    public final CategoryFilterType categoryFilterType() {
        return CategoryFilterType.fromValue(this.categoryFilterType);
    }

    public final String categoryFilterTypeAsString() {
        return this.categoryFilterType;
    }

    public final TopicCategoryFilterConstant constant() {
        return this.constant;
    }

    public final Boolean inverse() {
        return this.inverse;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryFilterFunctionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryFilterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.constant());
        hashCode = 31 * hashCode + Objects.hashCode(this.inverse());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicCategoryFilter)) {
            return false;
        }
        TopicCategoryFilter other = (TopicCategoryFilter)obj;
        return Objects.equals(this.categoryFilterFunctionAsString(), other.categoryFilterFunctionAsString()) && Objects.equals(this.categoryFilterTypeAsString(), other.categoryFilterTypeAsString()) && Objects.equals(this.constant(), other.constant()) && Objects.equals(this.inverse(), other.inverse());
    }

    public final String toString() {
        return ToString.builder((String)"TopicCategoryFilter").add("CategoryFilterFunction", (Object)this.categoryFilterFunctionAsString()).add("CategoryFilterType", (Object)this.categoryFilterTypeAsString()).add("Constant", (Object)(this.constant() == null ? null : "*** Sensitive Data Redacted ***")).add("Inverse", (Object)this.inverse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CategoryFilterFunction": {
                return Optional.ofNullable(clazz.cast(this.categoryFilterFunctionAsString()));
            }
            case "CategoryFilterType": {
                return Optional.ofNullable(clazz.cast(this.categoryFilterTypeAsString()));
            }
            case "Constant": {
                return Optional.ofNullable(clazz.cast(this.constant()));
            }
            case "Inverse": {
                return Optional.ofNullable(clazz.cast(this.inverse()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicCategoryFilter, T> g) {
        return obj -> g.apply((TopicCategoryFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String categoryFilterFunction;
        private String categoryFilterType;
        private TopicCategoryFilterConstant constant;
        private Boolean inverse;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicCategoryFilter model) {
            this.categoryFilterFunction(model.categoryFilterFunction);
            this.categoryFilterType(model.categoryFilterType);
            this.constant(model.constant);
            this.inverse(model.inverse);
        }

        public final String getCategoryFilterFunction() {
            return this.categoryFilterFunction;
        }

        public final void setCategoryFilterFunction(String categoryFilterFunction) {
            this.categoryFilterFunction = categoryFilterFunction;
        }

        @Override
        public final Builder categoryFilterFunction(String categoryFilterFunction) {
            this.categoryFilterFunction = categoryFilterFunction;
            return this;
        }

        @Override
        public final Builder categoryFilterFunction(CategoryFilterFunction categoryFilterFunction) {
            this.categoryFilterFunction(categoryFilterFunction == null ? null : categoryFilterFunction.toString());
            return this;
        }

        public final String getCategoryFilterType() {
            return this.categoryFilterType;
        }

        public final void setCategoryFilterType(String categoryFilterType) {
            this.categoryFilterType = categoryFilterType;
        }

        @Override
        public final Builder categoryFilterType(String categoryFilterType) {
            this.categoryFilterType = categoryFilterType;
            return this;
        }

        @Override
        public final Builder categoryFilterType(CategoryFilterType categoryFilterType) {
            this.categoryFilterType(categoryFilterType == null ? null : categoryFilterType.toString());
            return this;
        }

        public final TopicCategoryFilterConstant.Builder getConstant() {
            return this.constant != null ? this.constant.toBuilder() : null;
        }

        public final void setConstant(TopicCategoryFilterConstant.BuilderImpl constant) {
            this.constant = constant != null ? constant.build() : null;
        }

        @Override
        public final Builder constant(TopicCategoryFilterConstant constant) {
            this.constant = constant;
            return this;
        }

        public final Boolean getInverse() {
            return this.inverse;
        }

        public final void setInverse(Boolean inverse) {
            this.inverse = inverse;
        }

        @Override
        public final Builder inverse(Boolean inverse) {
            this.inverse = inverse;
            return this;
        }

        public TopicCategoryFilter build() {
            return new TopicCategoryFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopicCategoryFilter> {
        public Builder categoryFilterFunction(String var1);

        public Builder categoryFilterFunction(CategoryFilterFunction var1);

        public Builder categoryFilterType(String var1);

        public Builder categoryFilterType(CategoryFilterType var1);

        public Builder constant(TopicCategoryFilterConstant var1);

        default public Builder constant(Consumer<TopicCategoryFilterConstant.Builder> constant) {
            return this.constant((TopicCategoryFilterConstant)((TopicCategoryFilterConstant.Builder)TopicCategoryFilterConstant.builder().applyMutation(constant)).build());
        }

        public Builder inverse(Boolean var1);
    }
}

