/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.NamedEntityDefinition;
import software.amazon.awssdk.services.quicksight.model.NamedEntityDefinitionsCopier;
import software.amazon.awssdk.services.quicksight.model.SemanticEntityType;
import software.amazon.awssdk.services.quicksight.model.SynonymsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicNamedEntity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopicNamedEntity> {
    private static final SdkField<String> ENTITY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityName").getter(TopicNamedEntity.getter(TopicNamedEntity::entityName)).setter(TopicNamedEntity.setter(Builder::entityName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityName").build()}).build();
    private static final SdkField<String> ENTITY_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityDescription").getter(TopicNamedEntity.getter(TopicNamedEntity::entityDescription)).setter(TopicNamedEntity.setter(Builder::entityDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityDescription").build()}).build();
    private static final SdkField<List<String>> ENTITY_SYNONYMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EntitySynonyms").getter(TopicNamedEntity.getter(TopicNamedEntity::entitySynonyms)).setter(TopicNamedEntity.setter(Builder::entitySynonyms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntitySynonyms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SemanticEntityType> SEMANTIC_ENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SemanticEntityType").getter(TopicNamedEntity.getter(TopicNamedEntity::semanticEntityType)).setter(TopicNamedEntity.setter(Builder::semanticEntityType)).constructor(SemanticEntityType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SemanticEntityType").build()}).build();
    private static final SdkField<List<NamedEntityDefinition>> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Definition").getter(TopicNamedEntity.getter(TopicNamedEntity::definition)).setter(TopicNamedEntity.setter(Builder::definition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NamedEntityDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_NAME_FIELD, ENTITY_DESCRIPTION_FIELD, ENTITY_SYNONYMS_FIELD, SEMANTIC_ENTITY_TYPE_FIELD, DEFINITION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String entityName;
    private final String entityDescription;
    private final List<String> entitySynonyms;
    private final SemanticEntityType semanticEntityType;
    private final List<NamedEntityDefinition> definition;

    private TopicNamedEntity(BuilderImpl builder) {
        this.entityName = builder.entityName;
        this.entityDescription = builder.entityDescription;
        this.entitySynonyms = builder.entitySynonyms;
        this.semanticEntityType = builder.semanticEntityType;
        this.definition = builder.definition;
    }

    public final String entityName() {
        return this.entityName;
    }

    public final String entityDescription() {
        return this.entityDescription;
    }

    public final boolean hasEntitySynonyms() {
        return this.entitySynonyms != null && !(this.entitySynonyms instanceof SdkAutoConstructList);
    }

    public final List<String> entitySynonyms() {
        return this.entitySynonyms;
    }

    public final SemanticEntityType semanticEntityType() {
        return this.semanticEntityType;
    }

    public final boolean hasDefinition() {
        return this.definition != null && !(this.definition instanceof SdkAutoConstructList);
    }

    public final List<NamedEntityDefinition> definition() {
        return this.definition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entityName());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntitySynonyms() ? this.entitySynonyms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.semanticEntityType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefinition() ? this.definition() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicNamedEntity)) {
            return false;
        }
        TopicNamedEntity other = (TopicNamedEntity)obj;
        return Objects.equals(this.entityName(), other.entityName()) && Objects.equals(this.entityDescription(), other.entityDescription()) && this.hasEntitySynonyms() == other.hasEntitySynonyms() && Objects.equals(this.entitySynonyms(), other.entitySynonyms()) && Objects.equals(this.semanticEntityType(), other.semanticEntityType()) && this.hasDefinition() == other.hasDefinition() && Objects.equals(this.definition(), other.definition());
    }

    public final String toString() {
        return ToString.builder((String)"TopicNamedEntity").add("EntityName", (Object)this.entityName()).add("EntityDescription", (Object)this.entityDescription()).add("EntitySynonyms", this.hasEntitySynonyms() ? this.entitySynonyms() : null).add("SemanticEntityType", (Object)this.semanticEntityType()).add("Definition", this.hasDefinition() ? this.definition() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EntityName": {
                return Optional.ofNullable(clazz.cast(this.entityName()));
            }
            case "EntityDescription": {
                return Optional.ofNullable(clazz.cast(this.entityDescription()));
            }
            case "EntitySynonyms": {
                return Optional.ofNullable(clazz.cast(this.entitySynonyms()));
            }
            case "SemanticEntityType": {
                return Optional.ofNullable(clazz.cast(this.semanticEntityType()));
            }
            case "Definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicNamedEntity, T> g) {
        return obj -> g.apply((TopicNamedEntity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String entityName;
        private String entityDescription;
        private List<String> entitySynonyms = DefaultSdkAutoConstructList.getInstance();
        private SemanticEntityType semanticEntityType;
        private List<NamedEntityDefinition> definition = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TopicNamedEntity model) {
            this.entityName(model.entityName);
            this.entityDescription(model.entityDescription);
            this.entitySynonyms(model.entitySynonyms);
            this.semanticEntityType(model.semanticEntityType);
            this.definition(model.definition);
        }

        public final String getEntityName() {
            return this.entityName;
        }

        public final void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        @Override
        public final Builder entityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        public final String getEntityDescription() {
            return this.entityDescription;
        }

        public final void setEntityDescription(String entityDescription) {
            this.entityDescription = entityDescription;
        }

        @Override
        public final Builder entityDescription(String entityDescription) {
            this.entityDescription = entityDescription;
            return this;
        }

        public final Collection<String> getEntitySynonyms() {
            if (this.entitySynonyms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.entitySynonyms;
        }

        public final void setEntitySynonyms(Collection<String> entitySynonyms) {
            this.entitySynonyms = SynonymsCopier.copy(entitySynonyms);
        }

        @Override
        public final Builder entitySynonyms(Collection<String> entitySynonyms) {
            this.entitySynonyms = SynonymsCopier.copy(entitySynonyms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitySynonyms(String ... entitySynonyms) {
            this.entitySynonyms(Arrays.asList(entitySynonyms));
            return this;
        }

        public final SemanticEntityType.Builder getSemanticEntityType() {
            return this.semanticEntityType != null ? this.semanticEntityType.toBuilder() : null;
        }

        public final void setSemanticEntityType(SemanticEntityType.BuilderImpl semanticEntityType) {
            this.semanticEntityType = semanticEntityType != null ? semanticEntityType.build() : null;
        }

        @Override
        public final Builder semanticEntityType(SemanticEntityType semanticEntityType) {
            this.semanticEntityType = semanticEntityType;
            return this;
        }

        public final List<NamedEntityDefinition.Builder> getDefinition() {
            List<NamedEntityDefinition.Builder> result = NamedEntityDefinitionsCopier.copyToBuilder(this.definition);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDefinition(Collection<NamedEntityDefinition.BuilderImpl> definition) {
            this.definition = NamedEntityDefinitionsCopier.copyFromBuilder(definition);
        }

        @Override
        public final Builder definition(Collection<NamedEntityDefinition> definition) {
            this.definition = NamedEntityDefinitionsCopier.copy(definition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder definition(NamedEntityDefinition ... definition) {
            this.definition(Arrays.asList(definition));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder definition(Consumer<NamedEntityDefinition.Builder> ... definition) {
            this.definition(Stream.of(definition).map(c -> (NamedEntityDefinition)((NamedEntityDefinition.Builder)NamedEntityDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TopicNamedEntity build() {
            return new TopicNamedEntity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopicNamedEntity> {
        public Builder entityName(String var1);

        public Builder entityDescription(String var1);

        public Builder entitySynonyms(Collection<String> var1);

        public Builder entitySynonyms(String ... var1);

        public Builder semanticEntityType(SemanticEntityType var1);

        default public Builder semanticEntityType(Consumer<SemanticEntityType.Builder> semanticEntityType) {
            return this.semanticEntityType((SemanticEntityType)((SemanticEntityType.Builder)SemanticEntityType.builder().applyMutation(semanticEntityType)).build());
        }

        public Builder definition(Collection<NamedEntityDefinition> var1);

        public Builder definition(NamedEntityDefinition ... var1);

        public Builder definition(Consumer<NamedEntityDefinition.Builder> ... var1);
    }
}

