/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.redshiftdata.DefaultRedshiftDataAsyncClient;
import software.amazon.awssdk.services.redshiftdata.DefaultRedshiftDataBaseClientBuilder;
import software.amazon.awssdk.services.redshiftdata.RedshiftDataAsyncClient;
import software.amazon.awssdk.services.redshiftdata.RedshiftDataAsyncClientBuilder;
import software.amazon.awssdk.services.redshiftdata.RedshiftDataServiceClientConfiguration;
import software.amazon.awssdk.services.redshiftdata.endpoints.RedshiftDataEndpointProvider;

@SdkInternalApi
final class DefaultRedshiftDataAsyncClientBuilder
extends DefaultRedshiftDataBaseClientBuilder<RedshiftDataAsyncClientBuilder, RedshiftDataAsyncClient>
implements RedshiftDataAsyncClientBuilder {
    DefaultRedshiftDataAsyncClientBuilder() {
    }

    @Override
    public DefaultRedshiftDataAsyncClientBuilder endpointProvider(RedshiftDataEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final RedshiftDataAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultRedshiftDataAsyncClientBuilder.validateClientOptions(clientConfiguration);
        RedshiftDataServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultRedshiftDataAsyncClient client = new DefaultRedshiftDataAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private RedshiftDataServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return RedshiftDataServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

