/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessClient;
import software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.RecoveryPoint;

public class ListRecoveryPointsIterable
implements SdkIterable<ListRecoveryPointsResponse> {
    private final RedshiftServerlessClient client;
    private final ListRecoveryPointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRecoveryPointsIterable(RedshiftServerlessClient client, ListRecoveryPointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRecoveryPointsResponseFetcher();
    }

    public Iterator<ListRecoveryPointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RecoveryPoint> recoveryPoints() {
        Function<ListRecoveryPointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.recoveryPoints() != null) {
                return response.recoveryPoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRecoveryPointsResponseFetcher
    implements SyncPageFetcher<ListRecoveryPointsResponse> {
        private ListRecoveryPointsResponseFetcher() {
        }

        public boolean hasNextPage(ListRecoveryPointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRecoveryPointsResponse nextPage(ListRecoveryPointsResponse previousPage) {
            if (previousPage == null) {
                return ListRecoveryPointsIterable.this.client.listRecoveryPoints(ListRecoveryPointsIterable.this.firstRequest);
            }
            return ListRecoveryPointsIterable.this.client.listRecoveryPoints((ListRecoveryPointsRequest)((Object)ListRecoveryPointsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

