/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53domains.model.PriceWithCurrency;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainPrice
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainPrice> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DomainPrice.getter(DomainPrice::name)).setter(DomainPrice.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<PriceWithCurrency> REGISTRATION_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RegistrationPrice").getter(DomainPrice.getter(DomainPrice::registrationPrice)).setter(DomainPrice.setter(Builder::registrationPrice)).constructor(PriceWithCurrency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationPrice").build()}).build();
    private static final SdkField<PriceWithCurrency> TRANSFER_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TransferPrice").getter(DomainPrice.getter(DomainPrice::transferPrice)).setter(DomainPrice.setter(Builder::transferPrice)).constructor(PriceWithCurrency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransferPrice").build()}).build();
    private static final SdkField<PriceWithCurrency> RENEWAL_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RenewalPrice").getter(DomainPrice.getter(DomainPrice::renewalPrice)).setter(DomainPrice.setter(Builder::renewalPrice)).constructor(PriceWithCurrency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenewalPrice").build()}).build();
    private static final SdkField<PriceWithCurrency> CHANGE_OWNERSHIP_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChangeOwnershipPrice").getter(DomainPrice.getter(DomainPrice::changeOwnershipPrice)).setter(DomainPrice.setter(Builder::changeOwnershipPrice)).constructor(PriceWithCurrency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeOwnershipPrice").build()}).build();
    private static final SdkField<PriceWithCurrency> RESTORATION_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RestorationPrice").getter(DomainPrice.getter(DomainPrice::restorationPrice)).setter(DomainPrice.setter(Builder::restorationPrice)).constructor(PriceWithCurrency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestorationPrice").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, REGISTRATION_PRICE_FIELD, TRANSFER_PRICE_FIELD, RENEWAL_PRICE_FIELD, CHANGE_OWNERSHIP_PRICE_FIELD, RESTORATION_PRICE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final PriceWithCurrency registrationPrice;
    private final PriceWithCurrency transferPrice;
    private final PriceWithCurrency renewalPrice;
    private final PriceWithCurrency changeOwnershipPrice;
    private final PriceWithCurrency restorationPrice;

    private DomainPrice(BuilderImpl builder) {
        this.name = builder.name;
        this.registrationPrice = builder.registrationPrice;
        this.transferPrice = builder.transferPrice;
        this.renewalPrice = builder.renewalPrice;
        this.changeOwnershipPrice = builder.changeOwnershipPrice;
        this.restorationPrice = builder.restorationPrice;
    }

    public final String name() {
        return this.name;
    }

    public final PriceWithCurrency registrationPrice() {
        return this.registrationPrice;
    }

    public final PriceWithCurrency transferPrice() {
        return this.transferPrice;
    }

    public final PriceWithCurrency renewalPrice() {
        return this.renewalPrice;
    }

    public final PriceWithCurrency changeOwnershipPrice() {
        return this.changeOwnershipPrice;
    }

    public final PriceWithCurrency restorationPrice() {
        return this.restorationPrice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.transferPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.renewalPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeOwnershipPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.restorationPrice());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainPrice)) {
            return false;
        }
        DomainPrice other = (DomainPrice)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.registrationPrice(), other.registrationPrice()) && Objects.equals(this.transferPrice(), other.transferPrice()) && Objects.equals(this.renewalPrice(), other.renewalPrice()) && Objects.equals(this.changeOwnershipPrice(), other.changeOwnershipPrice()) && Objects.equals(this.restorationPrice(), other.restorationPrice());
    }

    public final String toString() {
        return ToString.builder((String)"DomainPrice").add("Name", (Object)this.name()).add("RegistrationPrice", (Object)this.registrationPrice()).add("TransferPrice", (Object)this.transferPrice()).add("RenewalPrice", (Object)this.renewalPrice()).add("ChangeOwnershipPrice", (Object)this.changeOwnershipPrice()).add("RestorationPrice", (Object)this.restorationPrice()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RegistrationPrice": {
                return Optional.ofNullable(clazz.cast(this.registrationPrice()));
            }
            case "TransferPrice": {
                return Optional.ofNullable(clazz.cast(this.transferPrice()));
            }
            case "RenewalPrice": {
                return Optional.ofNullable(clazz.cast(this.renewalPrice()));
            }
            case "ChangeOwnershipPrice": {
                return Optional.ofNullable(clazz.cast(this.changeOwnershipPrice()));
            }
            case "RestorationPrice": {
                return Optional.ofNullable(clazz.cast(this.restorationPrice()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainPrice, T> g) {
        return obj -> g.apply((DomainPrice)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private PriceWithCurrency registrationPrice;
        private PriceWithCurrency transferPrice;
        private PriceWithCurrency renewalPrice;
        private PriceWithCurrency changeOwnershipPrice;
        private PriceWithCurrency restorationPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainPrice model) {
            this.name(model.name);
            this.registrationPrice(model.registrationPrice);
            this.transferPrice(model.transferPrice);
            this.renewalPrice(model.renewalPrice);
            this.changeOwnershipPrice(model.changeOwnershipPrice);
            this.restorationPrice(model.restorationPrice);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PriceWithCurrency.Builder getRegistrationPrice() {
            return this.registrationPrice != null ? this.registrationPrice.toBuilder() : null;
        }

        public final void setRegistrationPrice(PriceWithCurrency.BuilderImpl registrationPrice) {
            this.registrationPrice = registrationPrice != null ? registrationPrice.build() : null;
        }

        @Override
        public final Builder registrationPrice(PriceWithCurrency registrationPrice) {
            this.registrationPrice = registrationPrice;
            return this;
        }

        public final PriceWithCurrency.Builder getTransferPrice() {
            return this.transferPrice != null ? this.transferPrice.toBuilder() : null;
        }

        public final void setTransferPrice(PriceWithCurrency.BuilderImpl transferPrice) {
            this.transferPrice = transferPrice != null ? transferPrice.build() : null;
        }

        @Override
        public final Builder transferPrice(PriceWithCurrency transferPrice) {
            this.transferPrice = transferPrice;
            return this;
        }

        public final PriceWithCurrency.Builder getRenewalPrice() {
            return this.renewalPrice != null ? this.renewalPrice.toBuilder() : null;
        }

        public final void setRenewalPrice(PriceWithCurrency.BuilderImpl renewalPrice) {
            this.renewalPrice = renewalPrice != null ? renewalPrice.build() : null;
        }

        @Override
        public final Builder renewalPrice(PriceWithCurrency renewalPrice) {
            this.renewalPrice = renewalPrice;
            return this;
        }

        public final PriceWithCurrency.Builder getChangeOwnershipPrice() {
            return this.changeOwnershipPrice != null ? this.changeOwnershipPrice.toBuilder() : null;
        }

        public final void setChangeOwnershipPrice(PriceWithCurrency.BuilderImpl changeOwnershipPrice) {
            this.changeOwnershipPrice = changeOwnershipPrice != null ? changeOwnershipPrice.build() : null;
        }

        @Override
        public final Builder changeOwnershipPrice(PriceWithCurrency changeOwnershipPrice) {
            this.changeOwnershipPrice = changeOwnershipPrice;
            return this;
        }

        public final PriceWithCurrency.Builder getRestorationPrice() {
            return this.restorationPrice != null ? this.restorationPrice.toBuilder() : null;
        }

        public final void setRestorationPrice(PriceWithCurrency.BuilderImpl restorationPrice) {
            this.restorationPrice = restorationPrice != null ? restorationPrice.build() : null;
        }

        @Override
        public final Builder restorationPrice(PriceWithCurrency restorationPrice) {
            this.restorationPrice = restorationPrice;
            return this;
        }

        public DomainPrice build() {
            return new DomainPrice(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainPrice> {
        public Builder name(String var1);

        public Builder registrationPrice(PriceWithCurrency var1);

        default public Builder registrationPrice(Consumer<PriceWithCurrency.Builder> registrationPrice) {
            return this.registrationPrice((PriceWithCurrency)((PriceWithCurrency.Builder)PriceWithCurrency.builder().applyMutation(registrationPrice)).build());
        }

        public Builder transferPrice(PriceWithCurrency var1);

        default public Builder transferPrice(Consumer<PriceWithCurrency.Builder> transferPrice) {
            return this.transferPrice((PriceWithCurrency)((PriceWithCurrency.Builder)PriceWithCurrency.builder().applyMutation(transferPrice)).build());
        }

        public Builder renewalPrice(PriceWithCurrency var1);

        default public Builder renewalPrice(Consumer<PriceWithCurrency.Builder> renewalPrice) {
            return this.renewalPrice((PriceWithCurrency)((PriceWithCurrency.Builder)PriceWithCurrency.builder().applyMutation(renewalPrice)).build());
        }

        public Builder changeOwnershipPrice(PriceWithCurrency var1);

        default public Builder changeOwnershipPrice(Consumer<PriceWithCurrency.Builder> changeOwnershipPrice) {
            return this.changeOwnershipPrice((PriceWithCurrency)((PriceWithCurrency.Builder)PriceWithCurrency.builder().applyMutation(changeOwnershipPrice)).build());
        }

        public Builder restorationPrice(PriceWithCurrency var1);

        default public Builder restorationPrice(Consumer<PriceWithCurrency.Builder> restorationPrice) {
            return this.restorationPrice((PriceWithCurrency)((PriceWithCurrency.Builder)PriceWithCurrency.builder().applyMutation(restorationPrice)).build());
        }
    }
}

