/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableAttributeDefinition;
import software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableAttributeDefinitionListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableBillingModeSummary;
import software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableGlobalSecondaryIndex;
import software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableGlobalSecondaryIndexListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableKeySchema;
import software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableKeySchemaListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex;
import software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableLocalSecondaryIndexListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableProvisionedThroughput;
import software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableReplica;
import software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableReplicaListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableRestoreSummary;
import software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableSseDescription;
import software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableStreamSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsDynamoDbTableDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsDynamoDbTableDetails> {
    private static final SdkField<List<AwsDynamoDbTableAttributeDefinition>> ATTRIBUTE_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributeDefinitions").getter(AwsDynamoDbTableDetails.getter(AwsDynamoDbTableDetails::attributeDefinitions)).setter(AwsDynamoDbTableDetails.setter(Builder::attributeDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsDynamoDbTableAttributeDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AwsDynamoDbTableBillingModeSummary> BILLING_MODE_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BillingModeSummary").getter(AwsDynamoDbTableDetails.getter(AwsDynamoDbTableDetails::billingModeSummary)).setter(AwsDynamoDbTableDetails.setter(Builder::billingModeSummary)).constructor(AwsDynamoDbTableBillingModeSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingModeSummary").build()}).build();
    private static final SdkField<String> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationDateTime").getter(AwsDynamoDbTableDetails.getter(AwsDynamoDbTableDetails::creationDateTime)).setter(AwsDynamoDbTableDetails.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDateTime").build()}).build();
    private static final SdkField<List<AwsDynamoDbTableGlobalSecondaryIndex>> GLOBAL_SECONDARY_INDEXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GlobalSecondaryIndexes").getter(AwsDynamoDbTableDetails.getter(AwsDynamoDbTableDetails::globalSecondaryIndexes)).setter(AwsDynamoDbTableDetails.setter(Builder::globalSecondaryIndexes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSecondaryIndexes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsDynamoDbTableGlobalSecondaryIndex::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> GLOBAL_TABLE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalTableVersion").getter(AwsDynamoDbTableDetails.getter(AwsDynamoDbTableDetails::globalTableVersion)).setter(AwsDynamoDbTableDetails.setter(Builder::globalTableVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalTableVersion").build()}).build();
    private static final SdkField<Integer> ITEM_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ItemCount").getter(AwsDynamoDbTableDetails.getter(AwsDynamoDbTableDetails::itemCount)).setter(AwsDynamoDbTableDetails.setter(Builder::itemCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemCount").build()}).build();
    private static final SdkField<List<AwsDynamoDbTableKeySchema>> KEY_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("KeySchema").getter(AwsDynamoDbTableDetails.getter(AwsDynamoDbTableDetails::keySchema)).setter(AwsDynamoDbTableDetails.setter(Builder::keySchema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySchema").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsDynamoDbTableKeySchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LATEST_STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestStreamArn").getter(AwsDynamoDbTableDetails.getter(AwsDynamoDbTableDetails::latestStreamArn)).setter(AwsDynamoDbTableDetails.setter(Builder::latestStreamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestStreamArn").build()}).build();
    private static final SdkField<String> LATEST_STREAM_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestStreamLabel").getter(AwsDynamoDbTableDetails.getter(AwsDynamoDbTableDetails::latestStreamLabel)).setter(AwsDynamoDbTableDetails.setter(Builder::latestStreamLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestStreamLabel").build()}).build();
    private static final SdkField<List<AwsDynamoDbTableLocalSecondaryIndex>> LOCAL_SECONDARY_INDEXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LocalSecondaryIndexes").getter(AwsDynamoDbTableDetails.getter(AwsDynamoDbTableDetails::localSecondaryIndexes)).setter(AwsDynamoDbTableDetails.setter(Builder::localSecondaryIndexes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalSecondaryIndexes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsDynamoDbTableLocalSecondaryIndex::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AwsDynamoDbTableProvisionedThroughput> PROVISIONED_THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisionedThroughput").getter(AwsDynamoDbTableDetails.getter(AwsDynamoDbTableDetails::provisionedThroughput)).setter(AwsDynamoDbTableDetails.setter(Builder::provisionedThroughput)).constructor(AwsDynamoDbTableProvisionedThroughput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughput").build()}).build();
    private static final SdkField<List<AwsDynamoDbTableReplica>> REPLICAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Replicas").getter(AwsDynamoDbTableDetails.getter(AwsDynamoDbTableDetails::replicas)).setter(AwsDynamoDbTableDetails.setter(Builder::replicas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Replicas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsDynamoDbTableReplica::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AwsDynamoDbTableRestoreSummary> RESTORE_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RestoreSummary").getter(AwsDynamoDbTableDetails.getter(AwsDynamoDbTableDetails::restoreSummary)).setter(AwsDynamoDbTableDetails.setter(Builder::restoreSummary)).constructor(AwsDynamoDbTableRestoreSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreSummary").build()}).build();
    private static final SdkField<AwsDynamoDbTableSseDescription> SSE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SseDescription").getter(AwsDynamoDbTableDetails.getter(AwsDynamoDbTableDetails::sseDescription)).setter(AwsDynamoDbTableDetails.setter(Builder::sseDescription)).constructor(AwsDynamoDbTableSseDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SseDescription").build()}).build();
    private static final SdkField<AwsDynamoDbTableStreamSpecification> STREAM_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StreamSpecification").getter(AwsDynamoDbTableDetails.getter(AwsDynamoDbTableDetails::streamSpecification)).setter(AwsDynamoDbTableDetails.setter(Builder::streamSpecification)).constructor(AwsDynamoDbTableStreamSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamSpecification").build()}).build();
    private static final SdkField<String> TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableId").getter(AwsDynamoDbTableDetails.getter(AwsDynamoDbTableDetails::tableId)).setter(AwsDynamoDbTableDetails.setter(Builder::tableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableId").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(AwsDynamoDbTableDetails.getter(AwsDynamoDbTableDetails::tableName)).setter(AwsDynamoDbTableDetails.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<Long> TABLE_SIZE_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TableSizeBytes").getter(AwsDynamoDbTableDetails.getter(AwsDynamoDbTableDetails::tableSizeBytes)).setter(AwsDynamoDbTableDetails.setter(Builder::tableSizeBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableSizeBytes").build()}).build();
    private static final SdkField<String> TABLE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableStatus").getter(AwsDynamoDbTableDetails.getter(AwsDynamoDbTableDetails::tableStatus)).setter(AwsDynamoDbTableDetails.setter(Builder::tableStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_DEFINITIONS_FIELD, BILLING_MODE_SUMMARY_FIELD, CREATION_DATE_TIME_FIELD, GLOBAL_SECONDARY_INDEXES_FIELD, GLOBAL_TABLE_VERSION_FIELD, ITEM_COUNT_FIELD, KEY_SCHEMA_FIELD, LATEST_STREAM_ARN_FIELD, LATEST_STREAM_LABEL_FIELD, LOCAL_SECONDARY_INDEXES_FIELD, PROVISIONED_THROUGHPUT_FIELD, REPLICAS_FIELD, RESTORE_SUMMARY_FIELD, SSE_DESCRIPTION_FIELD, STREAM_SPECIFICATION_FIELD, TABLE_ID_FIELD, TABLE_NAME_FIELD, TABLE_SIZE_BYTES_FIELD, TABLE_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<AwsDynamoDbTableAttributeDefinition> attributeDefinitions;
    private final AwsDynamoDbTableBillingModeSummary billingModeSummary;
    private final String creationDateTime;
    private final List<AwsDynamoDbTableGlobalSecondaryIndex> globalSecondaryIndexes;
    private final String globalTableVersion;
    private final Integer itemCount;
    private final List<AwsDynamoDbTableKeySchema> keySchema;
    private final String latestStreamArn;
    private final String latestStreamLabel;
    private final List<AwsDynamoDbTableLocalSecondaryIndex> localSecondaryIndexes;
    private final AwsDynamoDbTableProvisionedThroughput provisionedThroughput;
    private final List<AwsDynamoDbTableReplica> replicas;
    private final AwsDynamoDbTableRestoreSummary restoreSummary;
    private final AwsDynamoDbTableSseDescription sseDescription;
    private final AwsDynamoDbTableStreamSpecification streamSpecification;
    private final String tableId;
    private final String tableName;
    private final Long tableSizeBytes;
    private final String tableStatus;

    private AwsDynamoDbTableDetails(BuilderImpl builder) {
        this.attributeDefinitions = builder.attributeDefinitions;
        this.billingModeSummary = builder.billingModeSummary;
        this.creationDateTime = builder.creationDateTime;
        this.globalSecondaryIndexes = builder.globalSecondaryIndexes;
        this.globalTableVersion = builder.globalTableVersion;
        this.itemCount = builder.itemCount;
        this.keySchema = builder.keySchema;
        this.latestStreamArn = builder.latestStreamArn;
        this.latestStreamLabel = builder.latestStreamLabel;
        this.localSecondaryIndexes = builder.localSecondaryIndexes;
        this.provisionedThroughput = builder.provisionedThroughput;
        this.replicas = builder.replicas;
        this.restoreSummary = builder.restoreSummary;
        this.sseDescription = builder.sseDescription;
        this.streamSpecification = builder.streamSpecification;
        this.tableId = builder.tableId;
        this.tableName = builder.tableName;
        this.tableSizeBytes = builder.tableSizeBytes;
        this.tableStatus = builder.tableStatus;
    }

    public final boolean hasAttributeDefinitions() {
        return this.attributeDefinitions != null && !(this.attributeDefinitions instanceof SdkAutoConstructList);
    }

    public final List<AwsDynamoDbTableAttributeDefinition> attributeDefinitions() {
        return this.attributeDefinitions;
    }

    public final AwsDynamoDbTableBillingModeSummary billingModeSummary() {
        return this.billingModeSummary;
    }

    public final String creationDateTime() {
        return this.creationDateTime;
    }

    public final boolean hasGlobalSecondaryIndexes() {
        return this.globalSecondaryIndexes != null && !(this.globalSecondaryIndexes instanceof SdkAutoConstructList);
    }

    public final List<AwsDynamoDbTableGlobalSecondaryIndex> globalSecondaryIndexes() {
        return this.globalSecondaryIndexes;
    }

    public final String globalTableVersion() {
        return this.globalTableVersion;
    }

    public final Integer itemCount() {
        return this.itemCount;
    }

    public final boolean hasKeySchema() {
        return this.keySchema != null && !(this.keySchema instanceof SdkAutoConstructList);
    }

    public final List<AwsDynamoDbTableKeySchema> keySchema() {
        return this.keySchema;
    }

    public final String latestStreamArn() {
        return this.latestStreamArn;
    }

    public final String latestStreamLabel() {
        return this.latestStreamLabel;
    }

    public final boolean hasLocalSecondaryIndexes() {
        return this.localSecondaryIndexes != null && !(this.localSecondaryIndexes instanceof SdkAutoConstructList);
    }

    public final List<AwsDynamoDbTableLocalSecondaryIndex> localSecondaryIndexes() {
        return this.localSecondaryIndexes;
    }

    public final AwsDynamoDbTableProvisionedThroughput provisionedThroughput() {
        return this.provisionedThroughput;
    }

    public final boolean hasReplicas() {
        return this.replicas != null && !(this.replicas instanceof SdkAutoConstructList);
    }

    public final List<AwsDynamoDbTableReplica> replicas() {
        return this.replicas;
    }

    public final AwsDynamoDbTableRestoreSummary restoreSummary() {
        return this.restoreSummary;
    }

    public final AwsDynamoDbTableSseDescription sseDescription() {
        return this.sseDescription;
    }

    public final AwsDynamoDbTableStreamSpecification streamSpecification() {
        return this.streamSpecification;
    }

    public final String tableId() {
        return this.tableId;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final Long tableSizeBytes() {
        return this.tableSizeBytes;
    }

    public final String tableStatus() {
        return this.tableStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeDefinitions() ? this.attributeDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.billingModeSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlobalSecondaryIndexes() ? this.globalSecondaryIndexes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.globalTableVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeySchema() ? this.keySchema() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.latestStreamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestStreamLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocalSecondaryIndexes() ? this.localSecondaryIndexes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicas() ? this.replicas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsDynamoDbTableDetails)) {
            return false;
        }
        AwsDynamoDbTableDetails other = (AwsDynamoDbTableDetails)obj;
        return this.hasAttributeDefinitions() == other.hasAttributeDefinitions() && Objects.equals(this.attributeDefinitions(), other.attributeDefinitions()) && Objects.equals(this.billingModeSummary(), other.billingModeSummary()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && this.hasGlobalSecondaryIndexes() == other.hasGlobalSecondaryIndexes() && Objects.equals(this.globalSecondaryIndexes(), other.globalSecondaryIndexes()) && Objects.equals(this.globalTableVersion(), other.globalTableVersion()) && Objects.equals(this.itemCount(), other.itemCount()) && this.hasKeySchema() == other.hasKeySchema() && Objects.equals(this.keySchema(), other.keySchema()) && Objects.equals(this.latestStreamArn(), other.latestStreamArn()) && Objects.equals(this.latestStreamLabel(), other.latestStreamLabel()) && this.hasLocalSecondaryIndexes() == other.hasLocalSecondaryIndexes() && Objects.equals(this.localSecondaryIndexes(), other.localSecondaryIndexes()) && Objects.equals(this.provisionedThroughput(), other.provisionedThroughput()) && this.hasReplicas() == other.hasReplicas() && Objects.equals(this.replicas(), other.replicas()) && Objects.equals(this.restoreSummary(), other.restoreSummary()) && Objects.equals(this.sseDescription(), other.sseDescription()) && Objects.equals(this.streamSpecification(), other.streamSpecification()) && Objects.equals(this.tableId(), other.tableId()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.tableSizeBytes(), other.tableSizeBytes()) && Objects.equals(this.tableStatus(), other.tableStatus());
    }

    public final String toString() {
        return ToString.builder((String)"AwsDynamoDbTableDetails").add("AttributeDefinitions", this.hasAttributeDefinitions() ? this.attributeDefinitions() : null).add("BillingModeSummary", (Object)this.billingModeSummary()).add("CreationDateTime", (Object)this.creationDateTime()).add("GlobalSecondaryIndexes", this.hasGlobalSecondaryIndexes() ? this.globalSecondaryIndexes() : null).add("GlobalTableVersion", (Object)this.globalTableVersion()).add("ItemCount", (Object)this.itemCount()).add("KeySchema", this.hasKeySchema() ? this.keySchema() : null).add("LatestStreamArn", (Object)this.latestStreamArn()).add("LatestStreamLabel", (Object)this.latestStreamLabel()).add("LocalSecondaryIndexes", this.hasLocalSecondaryIndexes() ? this.localSecondaryIndexes() : null).add("ProvisionedThroughput", (Object)this.provisionedThroughput()).add("Replicas", this.hasReplicas() ? this.replicas() : null).add("RestoreSummary", (Object)this.restoreSummary()).add("SseDescription", (Object)this.sseDescription()).add("StreamSpecification", (Object)this.streamSpecification()).add("TableId", (Object)this.tableId()).add("TableName", (Object)this.tableName()).add("TableSizeBytes", (Object)this.tableSizeBytes()).add("TableStatus", (Object)this.tableStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeDefinitions": {
                return Optional.ofNullable(clazz.cast(this.attributeDefinitions()));
            }
            case "BillingModeSummary": {
                return Optional.ofNullable(clazz.cast(this.billingModeSummary()));
            }
            case "CreationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "GlobalSecondaryIndexes": {
                return Optional.ofNullable(clazz.cast(this.globalSecondaryIndexes()));
            }
            case "GlobalTableVersion": {
                return Optional.ofNullable(clazz.cast(this.globalTableVersion()));
            }
            case "ItemCount": {
                return Optional.ofNullable(clazz.cast(this.itemCount()));
            }
            case "KeySchema": {
                return Optional.ofNullable(clazz.cast(this.keySchema()));
            }
            case "LatestStreamArn": {
                return Optional.ofNullable(clazz.cast(this.latestStreamArn()));
            }
            case "LatestStreamLabel": {
                return Optional.ofNullable(clazz.cast(this.latestStreamLabel()));
            }
            case "LocalSecondaryIndexes": {
                return Optional.ofNullable(clazz.cast(this.localSecondaryIndexes()));
            }
            case "ProvisionedThroughput": {
                return Optional.ofNullable(clazz.cast(this.provisionedThroughput()));
            }
            case "Replicas": {
                return Optional.ofNullable(clazz.cast(this.replicas()));
            }
            case "RestoreSummary": {
                return Optional.ofNullable(clazz.cast(this.restoreSummary()));
            }
            case "SseDescription": {
                return Optional.ofNullable(clazz.cast(this.sseDescription()));
            }
            case "StreamSpecification": {
                return Optional.ofNullable(clazz.cast(this.streamSpecification()));
            }
            case "TableId": {
                return Optional.ofNullable(clazz.cast(this.tableId()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "TableSizeBytes": {
                return Optional.ofNullable(clazz.cast(this.tableSizeBytes()));
            }
            case "TableStatus": {
                return Optional.ofNullable(clazz.cast(this.tableStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsDynamoDbTableDetails, T> g) {
        return obj -> g.apply((AwsDynamoDbTableDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AwsDynamoDbTableAttributeDefinition> attributeDefinitions = DefaultSdkAutoConstructList.getInstance();
        private AwsDynamoDbTableBillingModeSummary billingModeSummary;
        private String creationDateTime;
        private List<AwsDynamoDbTableGlobalSecondaryIndex> globalSecondaryIndexes = DefaultSdkAutoConstructList.getInstance();
        private String globalTableVersion;
        private Integer itemCount;
        private List<AwsDynamoDbTableKeySchema> keySchema = DefaultSdkAutoConstructList.getInstance();
        private String latestStreamArn;
        private String latestStreamLabel;
        private List<AwsDynamoDbTableLocalSecondaryIndex> localSecondaryIndexes = DefaultSdkAutoConstructList.getInstance();
        private AwsDynamoDbTableProvisionedThroughput provisionedThroughput;
        private List<AwsDynamoDbTableReplica> replicas = DefaultSdkAutoConstructList.getInstance();
        private AwsDynamoDbTableRestoreSummary restoreSummary;
        private AwsDynamoDbTableSseDescription sseDescription;
        private AwsDynamoDbTableStreamSpecification streamSpecification;
        private String tableId;
        private String tableName;
        private Long tableSizeBytes;
        private String tableStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsDynamoDbTableDetails model) {
            this.attributeDefinitions(model.attributeDefinitions);
            this.billingModeSummary(model.billingModeSummary);
            this.creationDateTime(model.creationDateTime);
            this.globalSecondaryIndexes(model.globalSecondaryIndexes);
            this.globalTableVersion(model.globalTableVersion);
            this.itemCount(model.itemCount);
            this.keySchema(model.keySchema);
            this.latestStreamArn(model.latestStreamArn);
            this.latestStreamLabel(model.latestStreamLabel);
            this.localSecondaryIndexes(model.localSecondaryIndexes);
            this.provisionedThroughput(model.provisionedThroughput);
            this.replicas(model.replicas);
            this.restoreSummary(model.restoreSummary);
            this.sseDescription(model.sseDescription);
            this.streamSpecification(model.streamSpecification);
            this.tableId(model.tableId);
            this.tableName(model.tableName);
            this.tableSizeBytes(model.tableSizeBytes);
            this.tableStatus(model.tableStatus);
        }

        public final List<AwsDynamoDbTableAttributeDefinition.Builder> getAttributeDefinitions() {
            List<AwsDynamoDbTableAttributeDefinition.Builder> result = AwsDynamoDbTableAttributeDefinitionListCopier.copyToBuilder(this.attributeDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributeDefinitions(Collection<AwsDynamoDbTableAttributeDefinition.BuilderImpl> attributeDefinitions) {
            this.attributeDefinitions = AwsDynamoDbTableAttributeDefinitionListCopier.copyFromBuilder(attributeDefinitions);
        }

        @Override
        public final Builder attributeDefinitions(Collection<AwsDynamoDbTableAttributeDefinition> attributeDefinitions) {
            this.attributeDefinitions = AwsDynamoDbTableAttributeDefinitionListCopier.copy(attributeDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeDefinitions(AwsDynamoDbTableAttributeDefinition ... attributeDefinitions) {
            this.attributeDefinitions(Arrays.asList(attributeDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeDefinitions(Consumer<AwsDynamoDbTableAttributeDefinition.Builder> ... attributeDefinitions) {
            this.attributeDefinitions(Stream.of(attributeDefinitions).map(c -> (AwsDynamoDbTableAttributeDefinition)((AwsDynamoDbTableAttributeDefinition.Builder)AwsDynamoDbTableAttributeDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AwsDynamoDbTableBillingModeSummary.Builder getBillingModeSummary() {
            return this.billingModeSummary != null ? this.billingModeSummary.toBuilder() : null;
        }

        public final void setBillingModeSummary(AwsDynamoDbTableBillingModeSummary.BuilderImpl billingModeSummary) {
            this.billingModeSummary = billingModeSummary != null ? billingModeSummary.build() : null;
        }

        @Override
        public final Builder billingModeSummary(AwsDynamoDbTableBillingModeSummary billingModeSummary) {
            this.billingModeSummary = billingModeSummary;
            return this;
        }

        public final String getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(String creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(String creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final List<AwsDynamoDbTableGlobalSecondaryIndex.Builder> getGlobalSecondaryIndexes() {
            List<AwsDynamoDbTableGlobalSecondaryIndex.Builder> result = AwsDynamoDbTableGlobalSecondaryIndexListCopier.copyToBuilder(this.globalSecondaryIndexes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlobalSecondaryIndexes(Collection<AwsDynamoDbTableGlobalSecondaryIndex.BuilderImpl> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = AwsDynamoDbTableGlobalSecondaryIndexListCopier.copyFromBuilder(globalSecondaryIndexes);
        }

        @Override
        public final Builder globalSecondaryIndexes(Collection<AwsDynamoDbTableGlobalSecondaryIndex> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = AwsDynamoDbTableGlobalSecondaryIndexListCopier.copy(globalSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(AwsDynamoDbTableGlobalSecondaryIndex ... globalSecondaryIndexes) {
            this.globalSecondaryIndexes(Arrays.asList(globalSecondaryIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(Consumer<AwsDynamoDbTableGlobalSecondaryIndex.Builder> ... globalSecondaryIndexes) {
            this.globalSecondaryIndexes(Stream.of(globalSecondaryIndexes).map(c -> (AwsDynamoDbTableGlobalSecondaryIndex)((AwsDynamoDbTableGlobalSecondaryIndex.Builder)AwsDynamoDbTableGlobalSecondaryIndex.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getGlobalTableVersion() {
            return this.globalTableVersion;
        }

        public final void setGlobalTableVersion(String globalTableVersion) {
            this.globalTableVersion = globalTableVersion;
        }

        @Override
        public final Builder globalTableVersion(String globalTableVersion) {
            this.globalTableVersion = globalTableVersion;
            return this;
        }

        public final Integer getItemCount() {
            return this.itemCount;
        }

        public final void setItemCount(Integer itemCount) {
            this.itemCount = itemCount;
        }

        @Override
        public final Builder itemCount(Integer itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public final List<AwsDynamoDbTableKeySchema.Builder> getKeySchema() {
            List<AwsDynamoDbTableKeySchema.Builder> result = AwsDynamoDbTableKeySchemaListCopier.copyToBuilder(this.keySchema);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKeySchema(Collection<AwsDynamoDbTableKeySchema.BuilderImpl> keySchema) {
            this.keySchema = AwsDynamoDbTableKeySchemaListCopier.copyFromBuilder(keySchema);
        }

        @Override
        public final Builder keySchema(Collection<AwsDynamoDbTableKeySchema> keySchema) {
            this.keySchema = AwsDynamoDbTableKeySchemaListCopier.copy(keySchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(AwsDynamoDbTableKeySchema ... keySchema) {
            this.keySchema(Arrays.asList(keySchema));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(Consumer<AwsDynamoDbTableKeySchema.Builder> ... keySchema) {
            this.keySchema(Stream.of(keySchema).map(c -> (AwsDynamoDbTableKeySchema)((AwsDynamoDbTableKeySchema.Builder)AwsDynamoDbTableKeySchema.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLatestStreamArn() {
            return this.latestStreamArn;
        }

        public final void setLatestStreamArn(String latestStreamArn) {
            this.latestStreamArn = latestStreamArn;
        }

        @Override
        public final Builder latestStreamArn(String latestStreamArn) {
            this.latestStreamArn = latestStreamArn;
            return this;
        }

        public final String getLatestStreamLabel() {
            return this.latestStreamLabel;
        }

        public final void setLatestStreamLabel(String latestStreamLabel) {
            this.latestStreamLabel = latestStreamLabel;
        }

        @Override
        public final Builder latestStreamLabel(String latestStreamLabel) {
            this.latestStreamLabel = latestStreamLabel;
            return this;
        }

        public final List<AwsDynamoDbTableLocalSecondaryIndex.Builder> getLocalSecondaryIndexes() {
            List<AwsDynamoDbTableLocalSecondaryIndex.Builder> result = AwsDynamoDbTableLocalSecondaryIndexListCopier.copyToBuilder(this.localSecondaryIndexes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocalSecondaryIndexes(Collection<AwsDynamoDbTableLocalSecondaryIndex.BuilderImpl> localSecondaryIndexes) {
            this.localSecondaryIndexes = AwsDynamoDbTableLocalSecondaryIndexListCopier.copyFromBuilder(localSecondaryIndexes);
        }

        @Override
        public final Builder localSecondaryIndexes(Collection<AwsDynamoDbTableLocalSecondaryIndex> localSecondaryIndexes) {
            this.localSecondaryIndexes = AwsDynamoDbTableLocalSecondaryIndexListCopier.copy(localSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localSecondaryIndexes(AwsDynamoDbTableLocalSecondaryIndex ... localSecondaryIndexes) {
            this.localSecondaryIndexes(Arrays.asList(localSecondaryIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localSecondaryIndexes(Consumer<AwsDynamoDbTableLocalSecondaryIndex.Builder> ... localSecondaryIndexes) {
            this.localSecondaryIndexes(Stream.of(localSecondaryIndexes).map(c -> (AwsDynamoDbTableLocalSecondaryIndex)((AwsDynamoDbTableLocalSecondaryIndex.Builder)AwsDynamoDbTableLocalSecondaryIndex.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AwsDynamoDbTableProvisionedThroughput.Builder getProvisionedThroughput() {
            return this.provisionedThroughput != null ? this.provisionedThroughput.toBuilder() : null;
        }

        public final void setProvisionedThroughput(AwsDynamoDbTableProvisionedThroughput.BuilderImpl provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput != null ? provisionedThroughput.build() : null;
        }

        @Override
        public final Builder provisionedThroughput(AwsDynamoDbTableProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final List<AwsDynamoDbTableReplica.Builder> getReplicas() {
            List<AwsDynamoDbTableReplica.Builder> result = AwsDynamoDbTableReplicaListCopier.copyToBuilder(this.replicas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicas(Collection<AwsDynamoDbTableReplica.BuilderImpl> replicas) {
            this.replicas = AwsDynamoDbTableReplicaListCopier.copyFromBuilder(replicas);
        }

        @Override
        public final Builder replicas(Collection<AwsDynamoDbTableReplica> replicas) {
            this.replicas = AwsDynamoDbTableReplicaListCopier.copy(replicas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicas(AwsDynamoDbTableReplica ... replicas) {
            this.replicas(Arrays.asList(replicas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicas(Consumer<AwsDynamoDbTableReplica.Builder> ... replicas) {
            this.replicas(Stream.of(replicas).map(c -> (AwsDynamoDbTableReplica)((AwsDynamoDbTableReplica.Builder)AwsDynamoDbTableReplica.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AwsDynamoDbTableRestoreSummary.Builder getRestoreSummary() {
            return this.restoreSummary != null ? this.restoreSummary.toBuilder() : null;
        }

        public final void setRestoreSummary(AwsDynamoDbTableRestoreSummary.BuilderImpl restoreSummary) {
            this.restoreSummary = restoreSummary != null ? restoreSummary.build() : null;
        }

        @Override
        public final Builder restoreSummary(AwsDynamoDbTableRestoreSummary restoreSummary) {
            this.restoreSummary = restoreSummary;
            return this;
        }

        public final AwsDynamoDbTableSseDescription.Builder getSseDescription() {
            return this.sseDescription != null ? this.sseDescription.toBuilder() : null;
        }

        public final void setSseDescription(AwsDynamoDbTableSseDescription.BuilderImpl sseDescription) {
            this.sseDescription = sseDescription != null ? sseDescription.build() : null;
        }

        @Override
        public final Builder sseDescription(AwsDynamoDbTableSseDescription sseDescription) {
            this.sseDescription = sseDescription;
            return this;
        }

        public final AwsDynamoDbTableStreamSpecification.Builder getStreamSpecification() {
            return this.streamSpecification != null ? this.streamSpecification.toBuilder() : null;
        }

        public final void setStreamSpecification(AwsDynamoDbTableStreamSpecification.BuilderImpl streamSpecification) {
            this.streamSpecification = streamSpecification != null ? streamSpecification.build() : null;
        }

        @Override
        public final Builder streamSpecification(AwsDynamoDbTableStreamSpecification streamSpecification) {
            this.streamSpecification = streamSpecification;
            return this;
        }

        public final String getTableId() {
            return this.tableId;
        }

        public final void setTableId(String tableId) {
            this.tableId = tableId;
        }

        @Override
        public final Builder tableId(String tableId) {
            this.tableId = tableId;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final Long getTableSizeBytes() {
            return this.tableSizeBytes;
        }

        public final void setTableSizeBytes(Long tableSizeBytes) {
            this.tableSizeBytes = tableSizeBytes;
        }

        @Override
        public final Builder tableSizeBytes(Long tableSizeBytes) {
            this.tableSizeBytes = tableSizeBytes;
            return this;
        }

        public final String getTableStatus() {
            return this.tableStatus;
        }

        public final void setTableStatus(String tableStatus) {
            this.tableStatus = tableStatus;
        }

        @Override
        public final Builder tableStatus(String tableStatus) {
            this.tableStatus = tableStatus;
            return this;
        }

        public AwsDynamoDbTableDetails build() {
            return new AwsDynamoDbTableDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsDynamoDbTableDetails> {
        public Builder attributeDefinitions(Collection<AwsDynamoDbTableAttributeDefinition> var1);

        public Builder attributeDefinitions(AwsDynamoDbTableAttributeDefinition ... var1);

        public Builder attributeDefinitions(Consumer<AwsDynamoDbTableAttributeDefinition.Builder> ... var1);

        public Builder billingModeSummary(AwsDynamoDbTableBillingModeSummary var1);

        default public Builder billingModeSummary(Consumer<AwsDynamoDbTableBillingModeSummary.Builder> billingModeSummary) {
            return this.billingModeSummary((AwsDynamoDbTableBillingModeSummary)((AwsDynamoDbTableBillingModeSummary.Builder)AwsDynamoDbTableBillingModeSummary.builder().applyMutation(billingModeSummary)).build());
        }

        public Builder creationDateTime(String var1);

        public Builder globalSecondaryIndexes(Collection<AwsDynamoDbTableGlobalSecondaryIndex> var1);

        public Builder globalSecondaryIndexes(AwsDynamoDbTableGlobalSecondaryIndex ... var1);

        public Builder globalSecondaryIndexes(Consumer<AwsDynamoDbTableGlobalSecondaryIndex.Builder> ... var1);

        public Builder globalTableVersion(String var1);

        public Builder itemCount(Integer var1);

        public Builder keySchema(Collection<AwsDynamoDbTableKeySchema> var1);

        public Builder keySchema(AwsDynamoDbTableKeySchema ... var1);

        public Builder keySchema(Consumer<AwsDynamoDbTableKeySchema.Builder> ... var1);

        public Builder latestStreamArn(String var1);

        public Builder latestStreamLabel(String var1);

        public Builder localSecondaryIndexes(Collection<AwsDynamoDbTableLocalSecondaryIndex> var1);

        public Builder localSecondaryIndexes(AwsDynamoDbTableLocalSecondaryIndex ... var1);

        public Builder localSecondaryIndexes(Consumer<AwsDynamoDbTableLocalSecondaryIndex.Builder> ... var1);

        public Builder provisionedThroughput(AwsDynamoDbTableProvisionedThroughput var1);

        default public Builder provisionedThroughput(Consumer<AwsDynamoDbTableProvisionedThroughput.Builder> provisionedThroughput) {
            return this.provisionedThroughput((AwsDynamoDbTableProvisionedThroughput)((AwsDynamoDbTableProvisionedThroughput.Builder)AwsDynamoDbTableProvisionedThroughput.builder().applyMutation(provisionedThroughput)).build());
        }

        public Builder replicas(Collection<AwsDynamoDbTableReplica> var1);

        public Builder replicas(AwsDynamoDbTableReplica ... var1);

        public Builder replicas(Consumer<AwsDynamoDbTableReplica.Builder> ... var1);

        public Builder restoreSummary(AwsDynamoDbTableRestoreSummary var1);

        default public Builder restoreSummary(Consumer<AwsDynamoDbTableRestoreSummary.Builder> restoreSummary) {
            return this.restoreSummary((AwsDynamoDbTableRestoreSummary)((AwsDynamoDbTableRestoreSummary.Builder)AwsDynamoDbTableRestoreSummary.builder().applyMutation(restoreSummary)).build());
        }

        public Builder sseDescription(AwsDynamoDbTableSseDescription var1);

        default public Builder sseDescription(Consumer<AwsDynamoDbTableSseDescription.Builder> sseDescription) {
            return this.sseDescription((AwsDynamoDbTableSseDescription)((AwsDynamoDbTableSseDescription.Builder)AwsDynamoDbTableSseDescription.builder().applyMutation(sseDescription)).build());
        }

        public Builder streamSpecification(AwsDynamoDbTableStreamSpecification var1);

        default public Builder streamSpecification(Consumer<AwsDynamoDbTableStreamSpecification.Builder> streamSpecification) {
            return this.streamSpecification((AwsDynamoDbTableStreamSpecification)((AwsDynamoDbTableStreamSpecification.Builder)AwsDynamoDbTableStreamSpecification.builder().applyMutation(streamSpecification)).build());
        }

        public Builder tableId(String var1);

        public Builder tableName(String var1);

        public Builder tableSizeBytes(Long var1);

        public Builder tableStatus(String var1);
    }
}

