/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.snowball.SnowballClient;
import software.amazon.awssdk.services.snowball.internal.UserAgentUtils;
import software.amazon.awssdk.services.snowball.model.ListPickupLocationsRequest;
import software.amazon.awssdk.services.snowball.model.ListPickupLocationsResponse;

public class ListPickupLocationsIterable
implements SdkIterable<ListPickupLocationsResponse> {
    private final SnowballClient client;
    private final ListPickupLocationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPickupLocationsIterable(SnowballClient client, ListPickupLocationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPickupLocationsResponseFetcher();
    }

    public Iterator<ListPickupLocationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListPickupLocationsResponseFetcher
    implements SyncPageFetcher<ListPickupLocationsResponse> {
        private ListPickupLocationsResponseFetcher() {
        }

        public boolean hasNextPage(ListPickupLocationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPickupLocationsResponse nextPage(ListPickupLocationsResponse previousPage) {
            if (previousPage == null) {
                return ListPickupLocationsIterable.this.client.listPickupLocations(ListPickupLocationsIterable.this.firstRequest);
            }
            return ListPickupLocationsIterable.this.client.listPickupLocations((ListPickupLocationsRequest)((Object)ListPickupLocationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

