/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.snowball.SnowballAsyncClient;
import software.amazon.awssdk.services.snowball.internal.UserAgentUtils;
import software.amazon.awssdk.services.snowball.model.ListPickupLocationsRequest;
import software.amazon.awssdk.services.snowball.model.ListPickupLocationsResponse;

public class ListPickupLocationsPublisher
implements SdkPublisher<ListPickupLocationsResponse> {
    private final SnowballAsyncClient client;
    private final ListPickupLocationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPickupLocationsPublisher(SnowballAsyncClient client, ListPickupLocationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPickupLocationsPublisher(SnowballAsyncClient client, ListPickupLocationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPickupLocationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPickupLocationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListPickupLocationsResponseFetcher
    implements AsyncPageFetcher<ListPickupLocationsResponse> {
        private ListPickupLocationsResponseFetcher() {
        }

        public boolean hasNextPage(ListPickupLocationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPickupLocationsResponse> nextPage(ListPickupLocationsResponse previousPage) {
            if (previousPage == null) {
                return ListPickupLocationsPublisher.this.client.listPickupLocations(ListPickupLocationsPublisher.this.firstRequest);
            }
            return ListPickupLocationsPublisher.this.client.listPickupLocations((ListPickupLocationsRequest)((Object)ListPickupLocationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

