/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.backStageManagement.service;

import com.chinamcloud.haihe.backStageManagement.mapper.HaiheConfigMapper;
import com.chinamcloud.haihe.backStageManagement.pojo.HaiheConfig;
import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.Exception.CustomException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HaiheConfigService {
    private static Logger logger = LogManager.getLogger(HaiheConfigService.class);
    @Autowired
    private HaiheConfigMapper haiheConfigMapper;

    public Object getHaiheConfigByParam(String param) {
        if (StringUtils.isBlank((CharSequence)param)) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        HaiheConfig haiheConfig = this.haiheConfigMapper.selectByPrimaryKey(param);
        return new CodeResult<HaiheConfig>(CodeResult.Code.SUCCESS, haiheConfig);
    }

    @Transactional
    public Object updateHaiheConfig(HaiheConfig haiheConfig) {
        if (haiheConfig == null || StringUtils.isBlank((CharSequence)haiheConfig.getParam()) || StringUtils.isBlank((CharSequence)haiheConfig.getVal())) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            this.haiheConfigMapper.updateByPrimaryKeySelective(haiheConfig);
        }
        catch (Exception e) {
            logger.error("param:" + haiheConfig.getParam() + " --- " + "update_failed");
            throw new CustomException("update_failed");
        }
        return CodeResult.SUCCESSRESULT("success");
    }
}

