/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.backStageManagement.service;

import com.chinamcloud.haihe.backStageManagement.mapper.HaiheAreaMapper;
import com.chinamcloud.haihe.common.CodeResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class RegionService {
    @Autowired
    private HaiheAreaMapper haiheAreaMapper;
    private static Logger logger = LogManager.getLogger(RegionService.class);

    @Cacheable(value={"redis#3600"}, key="#root.methodName+#code", unless="#result == null")
    public CodeResult<List<Map<String, Object>>> getAddrTree(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            logger.error("params_error");
            return CodeResult.failedResultByMsgSource("params_error");
        }
        Integer provinceCode = null;
        try {
            provinceCode = Integer.valueOf(code);
        }
        catch (Exception e) {
            logger.error("params_error");
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        List<Map<String, Object>> city = this.haiheAreaMapper.getCity(provinceCode);
        if (city != null && !city.isEmpty()) {
            for (Map<String, Object> objectMap : city) {
                Integer cityCode = Integer.valueOf((String)objectMap.get("code"));
                List<Map<String, Object>> district = this.haiheAreaMapper.getDistrict(cityCode);
                objectMap.put("childList", district);
            }
            mapList.addAll(city);
        } else {
            List<Map<String, Object>> district = this.haiheAreaMapper.getDistrict(provinceCode);
            mapList.addAll(district);
        }
        if (mapList == null || mapList.isEmpty()) {
            logger.error("data_empty");
            return new CodeResult<List<Map<String, Object>>>(CodeResult.Code.SUCCESS, Collections.EMPTY_LIST);
        }
        return new CodeResult<List<Map<String, Object>>>(CodeResult.Code.SUCCESS, mapList);
    }

    @Cacheable(value={"redis#604800"}, key="#root.methodName+#root.targetClass", unless="#result == null")
    public CodeResult<List<Map<String, Object>>> getProvinces() {
        List<Map<String, Object>> city = this.haiheAreaMapper.getProvinces();
        if (city == null || city.isEmpty()) {
            logger.error("data_empty");
            return new CodeResult<List<Map<String, Object>>>(CodeResult.Code.SUCCESS, Collections.EMPTY_LIST);
        }
        return new CodeResult<List<Map<String, Object>>>(CodeResult.Code.SUCCESS, city);
    }

    public Object getAddr(Map<String, String> map) {
        String name = map.get("name");
        String code = map.get("code");
        List<Map<String, Object>> addr = this.haiheAreaMapper.getAddr(code, name);
        return new CodeResult<List<Map<String, Object>>>(CodeResult.Code.SUCCESS, addr);
    }
}

