/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.backStageManagement.service;

import com.chinamcloud.haihe.backStageManagement.mapper.SiteRequirementsMapper;
import com.chinamcloud.haihe.backStageManagement.pojo.SiteRequirements;
import com.chinamcloud.haihe.backStageManagement.pojo.SiteRequirementsParam;
import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.pojo.PagerResult;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SiteRequirementsService {
    private static Logger logger = LogManager.getLogger(SiteRequirementsService.class);
    @Autowired
    private SiteRequirementsMapper siteRequirementsMapper;

    public Object insert(SiteRequirements siteRequirements) {
        if (StringUtils.isBlank((CharSequence)siteRequirements.getUserToken()) || StringUtils.isBlank((CharSequence)siteRequirements.getSiteName()) || StringUtils.isBlank((CharSequence)siteRequirements.getUrl()) || siteRequirements.getPid() == null || StringUtils.isBlank((CharSequence)siteRequirements.getPids()) || siteRequirements.getSiteId() == null) {
            logger.error("\u6dfb\u52a0\u7ad9\u70b9\u9700\u6c42\u65f6 \u53c2\u6570\u9519\u8bef\uff1a" + siteRequirements.toString());
            return CodeResult.failedResultByMsgSource("params_error");
        }
        if (siteRequirements.getCreateTime() == null) {
            siteRequirements.setCreateTime(new Date(System.currentTimeMillis()));
        }
        this.siteRequirementsMapper.insert(siteRequirements);
        return new CodeResult(CodeResult.Code.SUCCESS);
    }

    public Object getSiteRequirementsList(SiteRequirementsParam param) {
        if (param.getPageNum() == null || param.getPageSize() == null) {
            logger.error("\u83b7\u53d6\u7ad9\u70b9\u9700\u6c42 \u53c2\u6570\u9519\u8bef!pageNum: " + param.getPageNum() + " - pageSize: " + param.getPageSize());
            return CodeResult.failedResultByMsgSource("params_error");
        }
        PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize());
        List<SiteRequirements> siteRequirementsList = this.siteRequirementsMapper.getSiteRequirementsList(param.getType(), param.getStatus());
        if (siteRequirementsList == null || siteRequirementsList.isEmpty()) {
            logger.error("data_empty");
            return new CodeResult<List<SiteRequirements>>(CodeResult.Code.SUCCESS, siteRequirementsList);
        }
        PageInfo pageInfo = new PageInfo(siteRequirementsList);
        PagerResult bean = new PagerResult();
        BeanUtils.copyProperties((Object)pageInfo, bean);
        return new CodeResult(CodeResult.Code.SUCCESS, bean);
    }

    public CodeResult<SiteRequirements> getSiteRequirementsBySiteId(Integer siteId) {
        if (siteId == null) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        SiteRequirements siteRequirements = this.siteRequirementsMapper.getSiteRequirementsBySiteId(siteId);
        return new CodeResult<SiteRequirements>(CodeResult.Code.SUCCESS, siteRequirements);
    }

    public Object update(SiteRequirements siteRequirements) {
        siteRequirements.setStatus((byte)0);
        this.siteRequirementsMapper.update(siteRequirements);
        return new CodeResult(CodeResult.Code.SUCCESS);
    }

    public Object getSiteBySiteId(SiteRequirements siteRequirements) {
        if (siteRequirements.getSiteId() == null) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        SiteRequirements siteRequire = this.siteRequirementsMapper.getSiteRequirementsBySiteId(siteRequirements.getSiteId());
        if (siteRequire != null) {
            siteRequirements.setStatus((byte)0);
            this.update(siteRequirements);
        }
        return new CodeResult<SiteRequirements>(CodeResult.Code.SUCCESS, siteRequire);
    }
}

