/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.common.afterprocessor;

import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.afterprocessor.IAfterProcessor;
import com.chinamcloud.haihe.common.bean.FacetResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ArealDistributionProcessor
implements IAfterProcessor<List<FacetResult>, CodeResult> {
    private static final long serialVersionUID = 2156801312453042263L;
    private final Map<String, String> areaMap = new HashMap<String, String>();

    public ArealDistributionProcessor(List<String> regionNames) {
        if (regionNames != null) {
            regionNames.stream().map(x -> {
                if (x.endsWith("\u7701")) {
                    this.areaMap.put(x.substring(0, x.lastIndexOf("\u7701")), (String)x);
                    return x.substring(0, x.lastIndexOf("\u7701"));
                }
                if (x.endsWith("\u5e02")) {
                    this.areaMap.put(x.substring(0, x.lastIndexOf("\u5e02")), (String)x);
                    return x.substring(0, x.lastIndexOf("\u5e02"));
                }
                if (x.endsWith("\u81ea\u6cbb\u533a")) {
                    this.areaMap.put(x.substring(0, x.lastIndexOf("\u81ea\u6cbb\u533a")), (String)x);
                    return x.substring(0, x.lastIndexOf("\u81ea\u6cbb\u533a"));
                }
                if (x.endsWith("\u7279\u522b\u884c\u653f\u533a")) {
                    this.areaMap.put(x.substring(0, x.lastIndexOf("\u7279\u522b\u884c\u653f\u533a")), (String)x);
                    return x.substring(0, x.lastIndexOf("\u7279\u522b\u884c\u653f\u533a"));
                }
                if (x.endsWith("\u533a")) {
                    this.areaMap.put(x.substring(0, x.lastIndexOf("\u533a")), (String)x);
                    return x.substring(0, x.lastIndexOf("\u533a"));
                }
                this.areaMap.put((String)x, (String)x);
                return x;
            }).collect(Collectors.toList());
        }
    }

    @Override
    public CodeResult process(List<FacetResult> facetResults) {
        if (facetResults != null) {
            ArrayList mapList = new ArrayList();
            for (FacetResult facetResult : facetResults) {
                if (!this.areaMap.keySet().contains(facetResult.getName())) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("key", this.areaMap.get(facetResult.getName()));
                map.put("count", facetResult.getValue() + "");
                mapList.add(map);
            }
            mapList.sort((o1, o2) -> Long.valueOf(o2.get("count").toString()).compareTo(Long.valueOf(o1.get("count").toString())));
            return new CodeResult(CodeResult.Code.Success, mapList);
        }
        return new CodeResult<List>(CodeResult.Code.Success, Collections.EMPTY_LIST);
    }
}

