/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.common.afterprocessor;

import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.afterprocessor.IAfterProcessor;
import com.chinamcloud.haihe.common.bean.Page;
import com.chinamcloud.haihe.common.pojo.SimpleNews;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NewDetailAfterProcessor
implements IAfterProcessor<Page<SimpleNews>, CodeResult> {
    private static final long serialVersionUID = 5935782869757255911L;
    private String type;
    private Integer size = null;
    private Integer page = null;

    public NewDetailAfterProcessor() {
    }

    public NewDetailAfterProcessor(String type) {
        this.type = type;
    }

    public NewDetailAfterProcessor(String type, Integer page, Integer size) {
        this.type = type;
        this.page = page;
        this.size = size;
    }

    @Override
    public CodeResult process(Page<SimpleNews> simpleNewsPage) {
        if ("list".equals(this.type)) {
            List<SimpleNews> records = simpleNewsPage.getRecords();
            if (records == null || records.isEmpty()) {
                return new CodeResult<List>(CodeResult.Code.Success, Collections.EMPTY_LIST);
            }
            if (this.page != null && this.size != null) {
                if ((this.page - 1) * this.size > records.size()) {
                    return new CodeResult<List>(CodeResult.Code.Success, Collections.EMPTY_LIST);
                }
                records = records.subList((this.page - 1) * this.size, Math.min(this.page * this.size, records.size()));
            }
            return new CodeResult<List<SimpleNews>>(CodeResult.Code.Success, records);
        }
        if ("page".equals(this.type)) {
            List<SimpleNews> records = simpleNewsPage.getRecords();
            if (records == null || records.isEmpty()) {
                return new CodeResult<Page<SimpleNews>>(CodeResult.Code.Success, simpleNewsPage);
            }
            if (this.page != null && this.size != null) {
                int records_size = records.size();
                records = (this.page - 1) * this.size >= records_size ? new ArrayList<SimpleNews>() : records.subList((this.page - 1) * this.size, Math.min(this.page * this.size, records_size));
                simpleNewsPage.setRecords(records);
                simpleNewsPage.setPageSize(this.size);
                simpleNewsPage.setTotalPages(records_size / this.size);
            }
        }
        return new CodeResult<Page<SimpleNews>>(CodeResult.Code.Success, simpleNewsPage);
    }
}

