/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.common.afterprocessor;

import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.afterprocessor.IAfterProcessor;
import com.chinamcloud.haihe.common.pojo.SimpleNews;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;

public class SimilarArticlesAfterProcessor
implements IAfterProcessor<Map<String, List<SimpleNews>>, CodeResult> {
    private static final long serialVersionUID = -2565795564079367679L;

    @Override
    public CodeResult process(Map<String, List<SimpleNews>> dataMap) {
        List<SimpleNews> records = dataMap.get("Original");
        List<SimpleNews> simpleNewsList = dataMap.get("similar");
        HashMap similarMap = new HashMap();
        simpleNewsList.stream().forEach(x -> {
            if (x.getClusterId() != null) {
                List simpleNews = (List)similarMap.get(x.getClusterId().toString());
                if (simpleNews != null) {
                    simpleNews.add(x);
                } else {
                    similarMap.put(x.getClusterId().toString(), new ArrayList<SimpleNews>(){
                        {
                            this.add(x);
                        }
                    });
                }
            }
        });
        ArrayList listMap = new ArrayList();
        for (final SimpleNews record : records) {
            HashMap<String, Serializable> map = new HashMap<String, Serializable>();
            map.put("data", record);
            if (record.getClusterId() == null) {
                map.put("nodes", new HashSet<Object>(){
                    {
                        this.add(new HashMap<String, String>(){
                            {
                                this.put("name", record.getParentSource());
                                this.put("time", record.getPubTime());
                                this.put("title", record.getTitle());
                            }
                        });
                        if (StringUtils.isNotBlank((CharSequence)record.getReprint())) {
                            this.add(new HashMap<String, String>(){
                                {
                                    this.put("name", record.getReprint());
                                    this.put("time", record.getPubTime());
                                    this.put("title", record.getTitle());
                                }
                            });
                        }
                    }
                });
                map.put("links", new ArrayList<Object>(){
                    {
                        if (StringUtils.isNotBlank((CharSequence)record.getParentSource()) && !record.getParentSource().equals(record.getReprint())) {
                            this.add(new HashMap<String, String>(){
                                {
                                    this.put("source", record.getParentSource());
                                    this.put("target", record.getReprint());
                                }
                            });
                        }
                    }
                });
                map.put("media", Integer.valueOf(1));
                map.put("books", Integer.valueOf(1));
                listMap.add(map);
                continue;
            }
            HashMap<String, SimpleNews> nodes = new HashMap<String, SimpleNews>();
            ArrayList<String> links = new ArrayList<String>();
            AtomicReference<Integer> books = new AtomicReference<Integer>(0);
            List simpleNews = (List)similarMap.get(record.getClusterId().toString());
            if (simpleNews != null) {
                for (SimpleNews x2 : simpleNews) {
                    if (!x2.getClusterId().equals(record.getClusterId())) continue;
                    books.getAndSet(books.get() + 1);
                    if (x2.getParentSource() != null) {
                        nodes.put(x2.getParentSource(), x2);
                    }
                    if (x2.getReprint() != null) {
                        nodes.put(x2.getReprint(), x2);
                    }
                    if (x2.getParentSource() == null || x2.getReprint() == null || x2.getReprint().equals(x2.getParentSource())) continue;
                    links.add(x2.getReprint() + "->" + x2.getParentSource());
                }
            }
            ArrayList linksMap = new ArrayList();
            links.stream().forEach(x -> linksMap.add(new HashMap<String, String>(){
                {
                    this.put("target", x.split("->")[0]);
                    this.put("source", x.split("->")[1]);
                }
            }));
            ArrayList<5> nodesMap = new ArrayList<5>();
            for (final Map.Entry entry : nodes.entrySet()) {
                nodesMap.add(new HashMap<String, String>(){
                    {
                        this.put("name", entry.getKey());
                        this.put("time", ((SimpleNews)entry.getValue()).getPubTime());
                        this.put("title", ((SimpleNews)entry.getValue()).getTitle());
                    }
                });
            }
            map.put("nodes", nodesMap);
            map.put("links", linksMap);
            map.put("media", Integer.valueOf(nodes.size()));
            map.put("books", books.get());
            listMap.add(map);
        }
        return new CodeResult(CodeResult.Code.Success, listMap);
    }
}

