/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.common.cache;

import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.chinamcloud.haihe.backStageManagement.pojo.Site;
import com.chinamcloud.haihe.common.cache.GenericFastJsonRedisSerializer;
import com.chinamcloud.haihe.common.cache.RedisAutoCacheManager;
import java.lang.reflect.Method;
import java.time.Duration;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.CacheErrorHandler;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.http.converter.HttpMessageConverter;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
@EnableCaching
public class RedisConfig
extends CachingConfigurerSupport {
    public static final String SEPARATOR = "#";
    private static final Logger logger = LoggerFactory.getLogger(RedisConfig.class);
    @Value(value="${spring.redis.host}")
    private String host;
    @Value(value="${spring.redis.port}")
    private int port;
    @Value(value="${spring.redis.timeout}")
    private int timeout;
    @Value(value="${spring.redis.lettuce.pool.max-idle}")
    private int maxIdle;
    @Value(value="${spring.redis.lettuce.pool.max-wait}")
    private long maxWaitMillis;
    @Value(value="${spring.redis.password}")
    private String password;
    @Value(value="${spring.redis.database}")
    private int dataBase;

    @Bean
    public RedisCacheManager cacheManager(RedisConnectionFactory connectionFactory) {
        StringRedisSerializer redisSerializer = new StringRedisSerializer();
        GenericFastJsonRedisSerializer<Object> genericFastJsonRedisSerializer = new GenericFastJsonRedisSerializer<Object>(Object.class);
        ParserConfig.getGlobalInstance().addAccept("com.chinamcloud.haihe");
        RedisCacheConfiguration redisCacheConfiguration = RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ofSeconds(15L)).serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)redisSerializer)).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer(genericFastJsonRedisSerializer)).disableCachingNullValues();
        RedisCacheWriter redisCacheWriter = RedisCacheWriter.nonLockingRedisCacheWriter((RedisConnectionFactory)connectionFactory);
        return new RedisAutoCacheManager(redisCacheWriter, redisCacheConfiguration);
    }

    private RedisSerializer<String> keySerializer() {
        return new StringRedisSerializer();
    }

    private GenericJackson2JsonRedisSerializer valueSerializer() {
        return new GenericJackson2JsonRedisSerializer();
    }

    public KeyGenerator keyGenerator() {
        return new KeyGenerator(){

            public Object generate(Object o, Method method, Object ... objects) {
                StringBuilder sb = new StringBuilder();
                sb.append(o.getClass().getName());
                sb.append(method.getName());
                for (Object obj : objects) {
                    sb.append(obj.toString());
                }
                return sb.toString();
            }
        };
    }

    @Bean(name={"firstParamAndMethodNameKeyGenerator"})
    public KeyGenerator firstParamAndMethodNameKeyGenerator() {
        return new KeyGenerator(){

            public Object generate(Object target, Method method, Object ... params) {
                StringBuilder sb = new StringBuilder();
                if (params.length != 0 && params[0] != null) {
                    sb.append(params[0].toString());
                }
                sb.append(target.getClass().getName());
                sb.append(method.getName());
                logger.info("redis-key:::" + sb.toString());
                return sb.toString();
            }
        };
    }

    @Bean(name={"firstParamAndMethodNam"})
    public KeyGenerator firstParamAndMethodNam() {
        return new KeyGenerator(){

            public Object generate(Object target, Method method, Object ... params) {
                StringBuilder sb = new StringBuilder();
                if (params.length != 0 && params[0] != null) {
                    sb.append(params[0].toString());
                }
                sb.append(method.getName());
                logger.info("redis-key:::" + sb.toString());
                return sb.toString();
            }
        };
    }

    @Bean(name={"paramKeyGenerator"})
    public KeyGenerator paramKeyGenerator() {
        return new KeyGenerator(){

            public Object generate(Object target, Method method, Object ... params) {
                StringBuilder sb = new StringBuilder();
                if (params.length != 0) {
                    for (Object param : params) {
                        if (param == null) continue;
                        sb.append(param.toString());
                    }
                } else {
                    sb.append(target.getClass().getName());
                    sb.append(method.getName());
                }
                logger.info("redis-key:::" + sb.toString());
                return sb.toString();
            }
        };
    }

    @Bean(name={"firstParamKeyGenerator"})
    public KeyGenerator firstParamKeyGenerator() {
        return new KeyGenerator(){

            public Object generate(Object target, Method method, Object ... params) {
                StringBuilder sb = new StringBuilder();
                if (params.length != 0) {
                    if (params[0] != null) {
                        if (params[0] instanceof Site) {
                            sb.append(((Site)params[0]).getSiteId());
                        } else {
                            sb.append(params[0].toString());
                        }
                    }
                } else {
                    sb.append(target.getClass().getName());
                    sb.append(method.getName());
                }
                logger.info("redis-key:::" + sb.toString());
                return sb.toString();
            }
        };
    }

    public CacheResolver cacheResolver() {
        return super.cacheResolver();
    }

    public CacheErrorHandler errorHandler() {
        return super.errorHandler();
    }

    @Bean
    public RedisTemplate<Object, Object> redisTemplate(RedisConnectionFactory factory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(factory);
        GenericFastJsonRedisSerializer<Object> genericFastJsonRedisSerializer = new GenericFastJsonRedisSerializer<Object>(Object.class);
        ParserConfig.getGlobalInstance().addAccept("com.chinamcloud.haihe");
        redisTemplate.setDefaultSerializer(genericFastJsonRedisSerializer);
        redisTemplate.setValueSerializer(genericFastJsonRedisSerializer);
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setHashValueSerializer(genericFastJsonRedisSerializer);
        redisTemplate.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }

    @Bean
    public HttpMessageConverters fastJsonHttpMessageConverters() {
        FastJsonHttpMessageConverter fastConverter = new FastJsonHttpMessageConverter();
        FastJsonConfig fastJsonConfig = new FastJsonConfig();
        fastJsonConfig.setSerializerFeatures(new SerializerFeature[]{SerializerFeature.PrettyFormat});
        fastConverter.setFastJsonConfig(fastJsonConfig);
        FastJsonHttpMessageConverter converter = fastConverter;
        return new HttpMessageConverters(new HttpMessageConverter[]{converter});
    }

    @Bean
    public JedisPool redisPoolFactory() {
        logger.info("JedisPool\u6ce8\u5165\u6210\u529f\uff01\uff01");
        logger.info("redis\u5730\u5740\uff1a" + this.host + ":" + this.port);
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxIdle(this.maxIdle);
        jedisPoolConfig.setMaxWaitMillis(this.maxWaitMillis);
        return new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, this.host, this.port, this.timeout, this.password, this.dataBase);
    }
}

