/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.common.cache;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Component
public class RedisUtil {
    private final JedisPool pool;

    @Autowired
    public RedisUtil(JedisPool pool) {
        this.pool = pool;
    }

    public boolean existsKey(String key) {
        try (Jedis jedis = this.pool.getResource();){
            boolean bl = jedis.exists(key);
            return bl;
        }
    }

    public boolean del(String key) {
        try (Jedis jedis = this.pool.getResource();){
            Long del = jedis.del(key);
            System.out.println("\u5220\u9664\uff1a" + del + "\u6761");
            boolean bl = del > 0L;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T getObj(String key, Class<T> clazz) {
        try (Jedis jedis = this.pool.getResource();){
            String value = jedis.get(key);
            if (StringUtils.isBlank((CharSequence)value)) {
                T t = null;
                return t;
            }
            Object object = JSON.parseObject((String)value, clazz);
            return (T)object;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void saveObj(Object object, int seconds, String key) {
        try (Jedis jedis = this.pool.getResource();){
            String jsonString = JSON.toJSONString((Object)object);
            jedis.setex(key, seconds, jsonString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> getObject(String key, Class<T> clazz) {
        Jedis jedis = this.pool.getResource();
        ByteArrayInputStream is = null;
        ObjectInputStream ois = null;
        try {
            byte[] b = jedis.get(key.getBytes());
            if (b == null) {
                List<T> list = null;
                return list;
            }
            is = new ByteArrayInputStream(b);
            ois = new ObjectInputStream(is);
            List list = (List)ois.readObject();
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (ois != null) {
                    ois.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            jedis.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveObject(Object object, int seconds, String key) {
        Jedis jedis = this.pool.getResource();
        ByteArrayOutputStream os = null;
        ObjectOutputStream oos = null;
        try {
            os = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(os);
            oos.writeObject(object);
            byte[] b = os.toByteArray();
            jedis.setex(key.getBytes(), seconds, b);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                os.close();
                oos.close();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            jedis.close();
        }
    }

    public void saveJsonArray(Object object, int seconds, String key) {
        try (Jedis jedis = this.pool.getResource();){
            String json = JSONArray.toJSONString((Object)object);
            jedis.setex(key, seconds, json);
        }
    }

    public <T> List<T> getJsonArray(String key, Class<T> clazz) {
        try (Jedis jedis = this.pool.getResource();){
            String str = jedis.get(key);
            List list = JSONArray.parseArray((String)str, clazz);
            return list;
        }
    }
}

