/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.common.spider.element;

import com.chinamcloud.haihe.common.spider.pojo.CountInfo;
import com.chinamcloud.haihe.common.spider.utils.TextUtils;
import java.util.HashMap;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class ContentElement {
    public static Element getContentElement(Document doc, HashMap<Element, CountInfo> infoMap) throws Exception {
        double maxScore = 0.0;
        Element content = null;
        for (Map.Entry<Element, CountInfo> entry : infoMap.entrySet()) {
            double score;
            Element tag = entry.getKey();
            if (tag.tagName().equals("a") || tag == doc.body()) continue;
            Document parse = Jsoup.parse((String)tag.toString());
            parse.select("a").remove();
            if (TextUtils.strSim(tag.text(), parse.text()) < 0.2 || !((score = CountInfo.computeScore(tag, infoMap)) > maxScore)) continue;
            maxScore = score;
            content = tag;
        }
        if (content == null) {
            throw new Exception("extraction failed");
        }
        return content;
    }
}

