/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.common.spider.element;

import com.chinamcloud.haihe.common.spider.utils.ElementUtils;
import com.chinamcloud.haihe.common.spider.utils.TextUtils;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class SourceElement {
    public static Element getSource(Element contentElement, Element titleElement, Element timeElement, List<Element> elementList) {
        List<Element> elements = null;
        if (timeElement != null) {
            Integer timeIndex = elementList.indexOf(timeElement);
            elements = elementList.subList(timeIndex >= 10 ? timeIndex - 10 : 0, timeIndex + 10);
        } else {
            Element source;
            if (contentElement == null) {
                return null;
            }
            Integer contentIndex = elementList.indexOf(contentElement);
            Integer titleIndex = 0;
            if (titleElement != null && (titleIndex = Integer.valueOf(elementList.indexOf(titleElement))) == -1) {
                titleIndex = elementList.indexOf(titleElement.parent());
            }
            Integer childNum = ElementUtils.getChildNum(contentElement);
            if (titleIndex < contentIndex) {
                elements = elementList.subList(titleIndex, contentIndex - childNum);
            }
            if ((source = SourceElement.getSource(elements)) == null) {
                elements = elementList.subList(contentIndex, contentIndex + 10 > elementList.size() ? elementList.size() : contentIndex + 10);
            } else {
                return source;
            }
        }
        return SourceElement.getSource(elements);
    }

    public static Element getSource(List<Element> elements) {
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            Element element = elements.get(i);
            Elements children = element.children();
            Element source = SourceElement.getSource((List<Element>)children);
            if (children != null && source != null) {
                return source;
            }
            if (!element.text().contains("\u6765\u6e90") && !element.text().contains("\u51fa\u5904")) continue;
            if (TextUtils.strSim(element.ownText(), "\u6765\u6e90") > 0.5 || TextUtils.strSim(element.ownText(), "\u51fa\u5904") > 0.5) {
                if (children == null || children.size() == 0) continue;
                String text = null;
                Element target = null;
                for (Element child : children) {
                    String reg;
                    Pattern p;
                    Matcher matcher;
                    boolean matches;
                    if (!StringUtils.isNotBlank((CharSequence)child.ownText().trim()) || (matches = (matcher = (p = Pattern.compile(reg = "[`~!@#$%^&*()_\\-+=<>?:\"{}|,.\\/;'\\[\\]\u00b7~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014\\-+={}|\u300a\u300b\uff1f\uff1a\u201c\u201d\u3010\u3011\u3001\uff1b\u2018\u2019\uff0c\u3002\u3001]")).matcher(child.ownText().trim())).matches())) continue;
                    text = child.ownText().trim();
                    target = child;
                }
                if (text != null || target != null) {
                    text = element.text().trim();
                    target = element;
                }
                return target;
            }
            return element;
        }
        return null;
    }
}

