/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.common.spider.processor;

import com.alibaba.fastjson.JSON;
import com.chinamcloud.haihe.backStageManagement.pojo.AppSpiderModel;
import com.chinamcloud.haihe.backStageManagement.pojo.AppSpiderTemplate;
import com.chinamcloud.haihe.backStageManagement.pojo.CrawlerOperation;
import com.chinamcloud.haihe.backStageManagement.pojo.Site;
import com.chinamcloud.haihe.backStageManagement.pojo.SiteInc;
import com.chinamcloud.haihe.backStageManagement.service.SiteManageService;
import com.chinamcloud.haihe.common.Exception.CustomException;
import com.chinamcloud.haihe.common.i18n.MessageSource;
import com.chinamcloud.haihe.common.spider.match.AppMatch;
import com.chinamcloud.haihe.common.spider.processor.BaseProcessor;
import com.chinamcloud.haihe.common.utils.HtmlUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppProcessor
implements BaseProcessor {
    private static Logger logger = LogManager.getLogger(AppProcessor.class);
    @Autowired
    private AppMatch appMatch;
    @Autowired
    private SiteManageService siteManageService;

    @Override
    public List<String> getListUrl(SiteInc siteInc, Site dbSite, String url, String charset, String detailsUrl) {
        AppSpiderModel listUrlsModel;
        ArrayList<String> newsList = new ArrayList<String>();
        AppSpiderTemplate appSpiderTemplate = siteInc.getAppSpiderTemplate();
        if (appSpiderTemplate == null) {
            if (dbSite == null || dbSite.getAppSpiderTemplate() == null) {
                throw new CustomException("site_template_cannot_be_empty");
            }
            appSpiderTemplate = dbSite.getAppSpiderTemplate();
        }
        if ((listUrlsModel = appSpiderTemplate.getListUrls()) == null) {
            throw new CustomException("listUrls_empty");
        }
        if (StringUtils.isNotBlank((CharSequence)detailsUrl)) {
            newsList.add(detailsUrl);
        } else {
            String htmlStr = this.siteManageService.getPage(url, charset);
            String flag = appSpiderTemplate.getFlag();
            String timeStamp = System.currentTimeMillis() + "";
            if ("0".equals(flag)) {
                ArrayList<String> placeholderIds = new ArrayList<String>();
                HtmlUtils.getDataListByJson(htmlStr, listUrlsModel.getPlaceholder(), placeholderIds);
                for (Object e : placeholderIds) {
                    String docId = e.toString();
                    String targetUrl = MessageFormat.format(listUrlsModel.getModel(), docId, timeStamp);
                    newsList.add(targetUrl);
                }
            } else if ("2".equals(flag)) {
                ArrayList<String> urlList = new ArrayList<String>();
                HtmlUtils.getDataListByJson(htmlStr, appSpiderTemplate.getPrefixUrl(), urlList);
                for (String targetUrl : urlList) {
                    try {
                        targetUrl = StringUtils.join((Object[])new String[]{appSpiderTemplate.getPrefixUrl(), URLDecoder.decode(targetUrl, "UTF8")});
                        newsList.add(targetUrl);
                    }
                    catch (UnsupportedEncodingException e) {
                        logger.warn("url decode error {}" + e.getMessage());
                    }
                }
            } else {
                ArrayList<String> list = new ArrayList<String>();
                HtmlUtils.getDataListByJson(htmlStr, listUrlsModel.getPath(), list);
                for (String targetUrl : list) {
                    try {
                        targetUrl = URLDecoder.decode(targetUrl, "UTF8");
                        newsList.add(targetUrl);
                    }
                    catch (UnsupportedEncodingException e) {
                        logger.warn("url decode error {}" + e.getMessage());
                    }
                }
            }
        }
        return newsList.size() > 10 ? newsList.subList(0, 10) : newsList;
    }

    @Override
    public CrawlerOperation crawlNew(List<String> newsList, SiteInc siteInc) {
        long beginTime = System.currentTimeMillis();
        Integer failedNum = 0;
        ArrayList<HashMap<String, Object>> mapList = new ArrayList<HashMap<String, Object>>();
        String charset = siteInc.getCharset();
        AppSpiderTemplate appSpiderTemplate = siteInc.getAppSpiderTemplate();
        Integer temp = 0;
        for (String url : newsList) {
            HashMap<String, Object> map;
            block16: {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                map = new HashMap<String, Object>();
                map.put("url", url);
                map.put("msg", "");
                String htmlStr = null;
                try {
                    htmlStr = this.siteManageService.getPage(url, charset);
                }
                catch (IllegalArgumentException e) {
                    String msg = (String)map.get("msg");
                    msg = msg + MessageSource.getMsg("news_links_exception");
                    map.put("msg", msg);
                    mapList.add(map);
                    return new CrawlerOperation(siteInc.getSiteId(), new Date(beginTime), System.currentTimeMillis() - beginTime, newsList.size(), newsList.size(), mapList, JSON.toJSONString(mapList), 4);
                }
                if (StringUtils.isBlank((CharSequence)htmlStr)) {
                    String msg = (String)map.get("msg");
                    msg = msg + MessageSource.getMsg("failed_to_get_HTML");
                    map.put("msg", msg);
                    mapList.add(map);
                    continue;
                }
                Future<Integer> subjectErrorNum = this.appMatch.getDataByType(htmlStr, appSpiderTemplate.getSubject(), null, map, "subject");
                Future<Integer> reprintErrorNum = this.appMatch.getDataByType(htmlStr, appSpiderTemplate.getReprint(), null, map, "reprint");
                Future<Integer> digestErrorNum = this.appMatch.getDataByType(htmlStr, appSpiderTemplate.getDigest(), null, map, "digest");
                Future<Integer> refererUrlErrorNum = this.appMatch.getDataByType(htmlStr, null, appSpiderTemplate.getRefererUrl(), map, "refererUrl");
                Future<Integer> picsErrorNum = this.appMatch.getDataByType(htmlStr, null, appSpiderTemplate.getPics(), map, "pics");
                Future<Integer> videosErrorNum = this.appMatch.getDataByType(htmlStr, null, appSpiderTemplate.getVideos(), map, "videos");
                Future<Integer> descriptionErrorNum = this.appMatch.getDataByType(htmlStr, appSpiderTemplate.getDescription(), null, map, "description");
                Future<Integer> pubTimeErrorNum = this.appMatch.getDataByType(htmlStr, appSpiderTemplate.getPubTime(), null, map, "pubTime");
                Future<Integer> coverErrorNum = this.appMatch.getDataByType(htmlStr, appSpiderTemplate.getCover(), null, map, "cover");
                try {
                    temp = subjectErrorNum.get() + reprintErrorNum.get() + digestErrorNum.get() + refererUrlErrorNum.get() + picsErrorNum.get() + videosErrorNum.get() + descriptionErrorNum.get() + pubTimeErrorNum.get() + coverErrorNum.get();
                }
                catch (InterruptedException e) {
                    logger.error("\u5f02\u6b65\u4efb\u52a1\u8fd4\u56de\u6570\u636e\u5931\u8d25\uff01");
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    logger.error("\u5f02\u6b65\u4efb\u52a1\u8fd4\u56de\u6570\u636e\u5931\u8d25\uff01");
                    e.printStackTrace();
                }
                String[] timePatterns = appSpiderTemplate.getTimePatterns();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                List pubTime = (List)map.get("pubTime");
                try {
                    if (pubTime != null && pubTime.get(0) != null && timePatterns != null) {
                        for (String timePattern : timePatterns) {
                            try {
                                Date time = DateUtils.parseDate((String)((String)pubTime.get(0)), (String[])new String[]{timePattern});
                                map.put("pubTime", sdf.format(time));
                                break block16;
                            }
                            catch (ParseException e) {
                                logger.warn("pubTime pattern error {}" + e.getMessage());
                            }
                        }
                        break block16;
                    }
                    if (pubTime != null && pubTime.get(0) != null) {
                        map.put("pubTime", sdf.format(new Date(Long.parseLong((String)pubTime.get(0)))));
                    }
                }
                catch (Exception exception) {
                    Integer n = temp;
                    Integer n2 = temp = Integer.valueOf(temp + 1);
                    logger.error("\u6293\u53d6\u6216\u8f6c\u6362\u53d1\u5e03\u65f6\u95f4\u5931\u8d25\uff0c\u4ee5\u5f53\u524d\u65f6\u95f4\u4f5c\u4e3a\u53d1\u5e03\u65f6\u95f4,error : {}" + exception.getMessage());
                    map.put("pubTime", sdf.format(new Date()));
                }
            }
            mapList.add(map);
            if (temp <= 0) continue;
            Integer n = failedNum;
            Integer n3 = failedNum = Integer.valueOf(failedNum + 1);
            temp = 0;
        }
        CrawlerOperation crawlerOperation = new CrawlerOperation(siteInc.getSiteId(), new Date(beginTime), System.currentTimeMillis() - beginTime, newsList.size(), failedNum, mapList, JSON.toJSONString(mapList), 4);
        return crawlerOperation;
    }
}

