/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.common.utils;

import com.chinamcloud.haihe.common.utils.ResultCode;

public class Result<T> {
    private Integer code;
    private String msg;
    private T data;

    private Result(ResultCode rc) {
        this.code = rc.getCode();
        this.msg = rc.getMsg();
    }

    private Result(ResultCode rc, T data) {
        this(rc);
        this.data = data;
    }

    public static <T> Result<T> success(T data) {
        return new Result<T>(ResultCode.OK, data);
    }

    public static <T> Result<T> error(ResultCode code, T data) {
        return new Result<T>(code, data);
    }

    public static Result<String> error(ResultCode code, Exception exception) {
        Result<String> result = new Result<String>(code);
        result.setData(exception.getMessage());
        return result;
    }

    public static Result<String> error(ResultCode code, String detailMessage) {
        Result<String> result = new Result<String>(code);
        result.setData(detailMessage);
        return result;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }
}

