/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.common.utils.encrypt;

import com.chinamcloud.haihe.common.utils.encrypt.HexUtil;
import com.chinamcloud.haihe.es.config.EsConfig;
import java.io.InputStreamReader;
import java.security.SecureRandom;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AES {
    private static Logger logger = LogManager.getLogger(AES.class);
    private static final String CONF_PATH = "config/encrypt.properties";
    private static final String DEFAULT_STRING;

    public static void main(String[] args) {
        try {
            String encrypt = AES.encrypt("text");
            System.out.println(encrypt);
            String aDefault = AES.decrypt(encrypt);
            System.out.println(aDefault);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String encrypt(String seed, String cleartext) throws Exception {
        byte[] rawKey = AES.getRawKey(seed.getBytes());
        byte[] result = AES.encrypt(rawKey, cleartext.getBytes());
        return HexUtil.toHex(result);
    }

    public static String encrypt(String cleartext) throws Exception {
        byte[] rawKey = AES.getRawKey(DEFAULT_STRING.getBytes());
        byte[] result = AES.encrypt(rawKey, cleartext.getBytes());
        return HexUtil.toHex(result);
    }

    public static String decrypt(String seed, String encrypted) throws Exception {
        byte[] rawKey = AES.getRawKey(seed.getBytes());
        byte[] enc = HexUtil.hextoBytes(encrypted);
        byte[] result = AES.decrypt(rawKey, enc);
        return new String(result);
    }

    public static String decrypt(String encrypted) throws Exception {
        byte[] rawKey = AES.getRawKey(DEFAULT_STRING.getBytes());
        byte[] enc = HexUtil.hextoBytes(encrypted);
        byte[] result = AES.decrypt(rawKey, enc);
        return new String(result);
    }

    private static byte[] getRawKey(byte[] seed) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
        sr.setSeed(seed);
        kgen.init(128, sr);
        SecretKey skey = kgen.generateKey();
        byte[] raw = skey.getEncoded();
        return raw;
    }

    public static byte[] encrypt(byte[] raw, byte[] clear) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, skeySpec);
        byte[] encrypted = cipher.doFinal(clear);
        return encrypted;
    }

    public static byte[] decrypt(byte[] raw, byte[] encrypted) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, skeySpec);
        byte[] decrypted = cipher.doFinal(encrypted);
        return decrypted;
    }

    static {
        Properties properties = new Properties();
        try {
            properties.load(new InputStreamReader(EsConfig.class.getClassLoader().getResourceAsStream(CONF_PATH), "UTF-8"));
        }
        catch (Exception e) {
            logger.error("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25!", (Throwable)e);
            System.exit(0);
        }
        DEFAULT_STRING = properties.getProperty("DEFAULT_STRING");
        if (StringUtils.isBlank((CharSequence)DEFAULT_STRING)) {
            logger.error("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25!");
            System.exit(0);
        }
    }
}

