/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.configService.service;

import com.alibaba.fastjson.JSON;
import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.configService.mapper.DpDataConfigMapper;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class DPDataConfigService {
    private static Logger logger = LogManager.getLogger(DPDataConfigService.class);
    private static ObjectMapper mapper = new ObjectMapper();
    @Autowired
    private DpDataConfigMapper dpDataconfigMapper;

    @Cacheable(value={"redis#60"}, keyGenerator="paramKeyGenerator", unless="#result.code == 1")
    public Object getDPDataConfig(String tenantId, String dpCode, String dpId) {
        if (StringUtils.isBlank((CharSequence)tenantId) || StringUtils.isBlank((CharSequence)dpCode) || StringUtils.isBlank((CharSequence)dpId)) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        String dpDataConfig = this.dpDataconfigMapper.getDPDataConfig(tenantId, dpCode, dpId);
        if (StringUtils.isBlank((CharSequence)dpDataConfig)) {
            logger.error("get_data_failed");
            return CodeResult.failedResultByMsgSource("get_data_failed");
        }
        return new CodeResult<Object>(CodeResult.Code.Success, JSON.parse((String)dpDataConfig));
    }
}

