/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.configService.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.configService.entity.DataConfig;
import com.chinamcloud.haihe.configService.mapper.DataConfigMapper;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class DataConfigService {
    private static Logger logger = LogManager.getLogger(DataConfigService.class);
    private static ObjectMapper mapper = new ObjectMapper();
    @Autowired
    private DataConfigMapper dataconfigMapper;

    @Cacheable(value={"redis#60"}, keyGenerator="paramKeyGenerator", unless="#result.code == 1")
    public Object getDataConfig(String tenantId, String dpCode, String dpId) {
        if (StringUtils.isBlank((CharSequence)tenantId) || StringUtils.isBlank((CharSequence)dpCode) || StringUtils.isBlank((CharSequence)dpId)) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        DataConfig dataConfig = this.selectByPrimaryKey(tenantId, dpCode, dpId);
        if (dataConfig == null || StringUtils.isBlank((CharSequence)dataConfig.getData())) {
            logger.error("get_data_failed");
            return CodeResult.failedResultByMsgSource("get_data_failed");
        }
        return new CodeResult<Object>(CodeResult.Code.Success, JSON.parse((String)dataConfig.getData()));
    }

    private DataConfig selectByPrimaryKey(String tenantId, String dpCode, String dpId) {
        return this.dataconfigMapper.selectByPrimaryKey(tenantId, dpCode, dpId);
    }

    public Object updateConfig(String tenantId, String dpCode, String dpId, String code, String name, String type) {
        if (StringUtils.isBlank((CharSequence)code) || StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)type)) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        int codeInt = Integer.parseInt(code);
        Object obj = this.getDataConfig(tenantId, dpCode, dpId);
        CodeResult codeResult = (CodeResult)obj;
        if (CodeResult.Code.Success.getCodeValue() != codeResult.getCode()) {
            return obj;
        }
        String resultMsg = "success";
        try {
            Object result = codeResult.getResult();
            JsonPath jsonPath_delete = JsonPath.compile((String)("$.*[?(@.code == " + codeInt + ")]"), (Predicate[])new Predicate[0]);
            DocumentContext document = JsonPath.parse(result);
            if ("delete".equals(type)) {
                document.delete(jsonPath_delete);
            } else if ("add".equals(type)) {
                List read = (List)document.read(jsonPath_delete);
                if (read == null || read.size() == 0) {
                    JSONObject json = new JSONObject();
                    json.put("code", (Object)codeInt);
                    json.put("name", (Object)name);
                    document.add(JsonPath.compile((String)"$.*", (Predicate[])new Predicate[0]), (Object)json);
                } else {
                    JsonPath jsonPath_update = JsonPath.compile((String)("$.*[?(@.code == " + codeInt + ")].name"), (Predicate[])new Predicate[0]);
                    document.set(jsonPath_update, (Object)name);
                    resultMsg = "config is exists , overwrite data !";
                }
            } else {
                JsonPath jsonPath_update = JsonPath.compile((String)("$.*[?(@.code == " + codeInt + ")].name"), (Predicate[])new Predicate[0]);
                document.set(jsonPath_update, (Object)name);
            }
            DataConfig dataConfig = new DataConfig();
            dataConfig.setId(dpId);
            dataConfig.setTenantId(tenantId);
            dataConfig.setCode(dpCode);
            dataConfig.setData(JSON.toJSONString(result));
            DataConfig selectByPrimaryKey = this.selectByPrimaryKey(tenantId, dpCode, dpId);
            if (selectByPrimaryKey == null || StringUtils.isBlank((CharSequence)selectByPrimaryKey.getTenantId())) {
                this.dataconfigMapper.insert(dataConfig);
            } else {
                this.dataconfigMapper.updateConfig(dataConfig);
            }
        }
        catch (Exception e) {
            logger.error("update_failedmsg:{}", (Object)e.getMessage());
            return CodeResult.failedResult("update config msg fail, msg :" + e.getMessage());
        }
        return new CodeResult(CodeResult.Code.Success, resultMsg);
    }

    public static void main(String[] args) {
        String jsonStr = "{\n \"classify\":[\n        {\"name\":\"\u4eba\u726921\",\"code\":0},\n        {\"name\":\"\u673a\u6784\",\"code\":1},\n        {\"name\":\"\u4ea7\u54c1\",\"code\":2},\n        {\"name\":\"\u54c1\u724c\",\"code\":3},\n        {\"name\":\"\u4e8b\u4ef6\",\"code\":4},\n        {\"name\":\"\u5176\u4ed6\",\"code\":5}\n        ]\n}";
        String code = "99";
        String name = "\u4eba\u72692122222";
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        DocumentContext document = JsonPath.parse((Object)jsonObject);
        List classify_name = (List)document.read("$.*[?(@.code == 1)].name", new Predicate[0]);
        System.out.println(classify_name.get(0));
    }
}

