/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.configService.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.configService.entity.DataConfig;
import com.chinamcloud.haihe.configService.mapper.DataConfigMapper;
import com.chinamcloud.haihe.configService.mapper.UserDataConfigMapper;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserDataConfigService {
    private static Logger logger = LogManager.getLogger(UserDataConfigService.class);
    private static ObjectMapper mapper = new ObjectMapper();
    @Autowired
    private UserDataConfigMapper userDataConfigMapper;
    @Autowired
    private DataConfigMapper dataconfigMapper;

    public Object getDataConfig(String tenantId, String dpCode, String dpId) {
        if (StringUtils.isBlank((CharSequence)tenantId) || StringUtils.isBlank((CharSequence)dpCode) || StringUtils.isBlank((CharSequence)dpId)) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        DataConfig dataConfig = this.selectByPrimaryKey(tenantId, dpCode, dpId);
        if (dataConfig == null || StringUtils.isBlank((CharSequence)dataConfig.getData())) {
            logger.error("get_data_failed");
            return CodeResult.failedResultByMsgSource("get_data_failed");
        }
        return new CodeResult<Object>(CodeResult.Code.Success, JSON.parse((String)dataConfig.getData()));
    }

    private DataConfig selectByPrimaryKey(String tenantId, String dpCode, String dpId) {
        DataConfig selectByPrimaryKey = this.userDataConfigMapper.selectByPrimaryKey(tenantId, dpCode, dpId);
        if (selectByPrimaryKey == null) {
            selectByPrimaryKey = this.dataconfigMapper.selectByPrimaryKey("default", dpCode, "1");
        }
        return selectByPrimaryKey;
    }

    public Object updateConfig(String tenantId, String dpCode, String dpId, String code, String name, String type) {
        if (StringUtils.isBlank((CharSequence)code) || StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)type)) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        Long codeInt = Long.parseLong(code);
        Object obj = this.getDataConfig(tenantId, dpCode, dpId);
        CodeResult codeResult = (CodeResult)obj;
        if (CodeResult.Code.Success.getCodeValue() != codeResult.getCode()) {
            return obj;
        }
        String resultMsg = "success";
        try {
            Object result = codeResult.getResult();
            JsonPath jsonPath_delete = JsonPath.compile((String)("$.*[?(@.code == " + codeInt + ")]"), (Predicate[])new Predicate[0]);
            DocumentContext document = JsonPath.parse(result);
            List type_Obj = (List)document.read(JsonPath.compile((String)("$.*[?(@.code == " + codeInt + ")].type"), (Predicate[])new Predicate[0]));
            List read_name = (List)document.read(JsonPath.compile((String)("$.*[?(@.name == '" + name + "')]"), (Predicate[])new Predicate[0]));
            if (type_Obj == null || type_Obj.isEmpty() || type_Obj != null && !type_Obj.isEmpty() && type_Obj.get(0).toString().equals("custom")) {
                JsonPath jsonPath_update;
                List read = (List)document.read(jsonPath_delete);
                if ("delete".equals(type)) {
                    document.delete(jsonPath_delete);
                } else if ("add".equals(type)) {
                    if (read_name == null || read_name.isEmpty()) {
                        if (read == null || read.size() == 0) {
                            JSONObject json = new JSONObject();
                            json.put("code", (Object)codeInt);
                            json.put("name", (Object)name);
                            json.put("type", (Object)"custom");
                            document.add(JsonPath.compile((String)"$.*", (Predicate[])new Predicate[0]), (Object)json);
                        } else {
                            jsonPath_update = JsonPath.compile((String)("$.*[?(@.code == " + codeInt + ")].name"), (Predicate[])new Predicate[0]);
                            document.set(jsonPath_update, (Object)name);
                            resultMsg = "config is exists , overwrite data !";
                        }
                    } else {
                        resultMsg = "config_name is exists !";
                    }
                } else if (read == null || read.size() == 0) {
                    resultMsg = "config is not exists !";
                } else {
                    jsonPath_update = JsonPath.compile((String)("$.*[?(@.code == " + codeInt + ")].name"), (Predicate[])new Predicate[0]);
                    document.set(jsonPath_update, (Object)name);
                }
            } else {
                resultMsg = "config  cannot be modified !";
            }
            DataConfig dataConfig = new DataConfig();
            dataConfig.setId(dpId);
            dataConfig.setTenantId(tenantId);
            dataConfig.setCode(dpCode);
            dataConfig.setData(JSON.toJSONString(result));
            DataConfig selectByPrimaryKey = this.userDataConfigMapper.selectByPrimaryKey(tenantId, dpCode, dpId);
            if (selectByPrimaryKey == null || StringUtils.isBlank((CharSequence)selectByPrimaryKey.getTenantId())) {
                this.userDataConfigMapper.insert(dataConfig);
            } else {
                this.userDataConfigMapper.updateConfig(dataConfig);
            }
        }
        catch (Exception e) {
            logger.error("update_failedmsg:{}", (Object)e.getMessage());
            return CodeResult.failedResult("update config msg fail, msg :" + e.getMessage());
        }
        return new CodeResult(CodeResult.Code.Success, resultMsg);
    }

    public static void setJsonPointerValue(ObjectNode node, JsonPointer pointer, JsonNode value) {
        JsonPointer parentPointer = pointer.head();
        JsonNode parentNode = node.at(parentPointer);
        String fieldName = pointer.last().toString().substring(1);
        if (parentNode.isMissingNode() || parentNode.isNull()) {
            parentNode = StringUtils.isNumeric((CharSequence)fieldName) ? mapper.createArrayNode() : mapper.createObjectNode();
            UserDataConfigService.setJsonPointerValue(node, parentPointer, parentNode);
        }
        if (parentNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)parentNode;
            int index = Integer.valueOf(fieldName);
            for (int i = arrayNode.size(); i <= index; ++i) {
                arrayNode.addNull();
            }
            arrayNode.set(index, value);
        } else if (parentNode.isObject()) {
            ((ObjectNode)parentNode).set(fieldName, value);
        } else {
            throw new IllegalArgumentException("`" + fieldName + "` can't be set for parent node `" + parentPointer + "` because parent is not a container but " + parentNode.getNodeType().name());
        }
    }

    public static void main(String[] args) {
        String json = "{\n  \"can delete\": \"this\",\n  \"can't delete\": \"this\"\n}";
        ObjectNode objectNode = mapper.createObjectNode();
        DocumentContext context = JsonPath.parse((String)json);
        context.set("$.['can delete']", null, new Predicate[0]);
        context.set("$.['can\\'t delete']", null, new Predicate[0]);
        context.set(JsonPath.compile((String)"$.['can\\'t delete123']", (Predicate[])new Predicate[0]), (Object)"John");
        System.out.println(context.jsonString());
    }
}

