/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.agg;

import com.chinamcloud.haihe.es.agg.IEsBuildAgg;
import com.chinamcloud.haihe.es.config.EsFeedbackQuery;
import com.chinamcloud.haihe.es.utils.TimeEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;

public class EsBuildEventStatisticAgg
implements IEsBuildAgg {
    private static Map<String, String> facetFieldMapping = new HashMap<String, String>();
    private static Logger logger;
    private String timeFormat = "";
    private String timeType = "hour";
    private Integer typeValue = 1;
    private Map<String, String> map;

    public EsBuildEventStatisticAgg(Map<String, String> map) {
        this.map = map;
    }

    public EsBuildEventStatisticAgg(Map<String, String> map, String timeFormat) {
        this.map = map;
        this.timeFormat = timeFormat;
    }

    public EsBuildEventStatisticAgg(Map<String, String> map, TimeEnum timeEnum) {
        this.map = map;
        this.timeFormat = timeEnum.getTimeFormat();
        this.timeType = timeEnum.getTimeType();
    }

    public EsBuildEventStatisticAgg(Map<String, String> map, String timeFormat, Integer typeValue) {
        this.map = map;
        this.timeFormat = timeFormat;
        this.typeValue = typeValue;
    }

    @Override
    public List<AggregationBuilder> buildAgg(EsFeedbackQuery query) {
        DateHistogramInterval interval = null;
        switch (this.timeType) {
            case "hour": {
                interval = DateHistogramInterval.hours((int)this.typeValue);
                break;
            }
            case "minute": {
                interval = DateHistogramInterval.minutes((int)this.typeValue);
                break;
            }
            case "second": {
                interval = DateHistogramInterval.seconds((int)this.typeValue);
                break;
            }
            case "day": {
                interval = DateHistogramInterval.days((int)this.typeValue);
                break;
            }
            case "week": {
                interval = DateHistogramInterval.weeks((int)this.typeValue);
                break;
            }
            case "month": {
                interval = DateHistogramInterval.MONTH;
                break;
            }
            case "quarter": {
                interval = DateHistogramInterval.QUARTER;
                break;
            }
            case "year": {
                interval = DateHistogramInterval.YEAR;
                break;
            }
            default: {
                interval = DateHistogramInterval.days((int)this.typeValue);
            }
        }
        if (this.map == null || this.map.isEmpty()) {
            logger.error("map is empty in the event statistics");
            return null;
        }
        ArrayList<AggregationBuilder> aggs = new ArrayList<AggregationBuilder>();
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            String value;
            String key = entry.getKey();
            switch (value = entry.getValue()) {
                case "avg": {
                    aggs.add((AggregationBuilder)AggregationBuilders.avg((String)key).field(facetFieldMapping.get(key)));
                    break;
                }
                case "cardinality": {
                    aggs.add((AggregationBuilder)AggregationBuilders.cardinality((String)key).field(facetFieldMapping.get(key)));
                    break;
                }
                case "terms": {
                    aggs.add((AggregationBuilder)AggregationBuilders.terms((String)key).field(facetFieldMapping.get(key)));
                    break;
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.timeFormat)) {
            DateHistogramAggregationBuilder format = (DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"agg").field("pubTimeStr")).dateHistogramInterval(interval).format(this.timeFormat);
            for (AggregationBuilder agg : aggs) {
                format.subAggregation(agg);
            }
            aggs.clear();
            aggs.add((AggregationBuilder)format);
        }
        return aggs;
    }

    static {
        facetFieldMapping.put("monitor_topic_id", "monitorTopicId");
        facetFieldMapping.put("crawler_keywords", "crawlerKeywords");
        facetFieldMapping.put("emotion_tendency", "emotionTendency");
        facetFieldMapping.put("emotion_score", "emotionScore");
        facetFieldMapping.put("cluster_id", "clusterId");
        facetFieldMapping.put("parent_source", "parentSource");
        facetFieldMapping.put("tb_nickname", "tbNickname.keyword");
        facetFieldMapping.put("source_id", "sourceId");
        facetFieldMapping.put("url_MD5", "urlMD5");
        facetFieldMapping.put("summary_keywords", "summaryKeywordList");
        facetFieldMapping.put("summary_phrase", "summaryPhrase");
        facetFieldMapping.put("spider_topicId", "spiderTopicId");
        facetFieldMapping.put("source", "source");
        facetFieldMapping.put("layout_index", "layoutIndex");
        facetFieldMapping.put("province", "province");
        logger = LogManager.getLogger(EsBuildEventStatisticAgg.class);
    }
}

