/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.agg;

import com.chinamcloud.haihe.es.agg.IEsBuildAgg;
import com.chinamcloud.haihe.es.config.EsFeedbackQuery;
import com.chinamcloud.haihe.es.pojo.TermAggBucket;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.filters.FiltersAggregator;

public class EsTermBucketAgg
implements IEsBuildAgg {
    List<TermAggBucket> termAggBuckets;

    public EsTermBucketAgg(List<TermAggBucket> termAggBuckets) {
        this.termAggBuckets = termAggBuckets;
    }

    @Override
    public List<AggregationBuilder> buildAgg(EsFeedbackQuery query) {
        if (this.termAggBuckets != null && !this.termAggBuckets.isEmpty()) {
            final List queryBuilders = this.termAggBuckets.stream().map(x -> {
                BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
                x.getValue().forEach(y -> {
                    if ("description".equals(x.getField())) {
                        boolQueryBuilder.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)x.getField(), (Object)y));
                    } else {
                        boolQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)x.getField(), (String)("*" + y + "*")));
                    }
                });
                return new FiltersAggregator.KeyedFilter(x.getAggName(), (QueryBuilder)boolQueryBuilder);
            }).collect(Collectors.toList());
            return new ArrayList<AggregationBuilder>(){
                {
                    this.add(AggregationBuilders.filters((String)"agg", (FiltersAggregator.KeyedFilter[])queryBuilders.toArray(new FiltersAggregator.KeyedFilter[queryBuilders.size()])));
                }
            };
        }
        return null;
    }
}

