/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.dao;

import com.chinamcloud.haihe.common.bean.NewsInfo;
import com.chinamcloud.haihe.common.utils.MD5;
import com.chinamcloud.haihe.es.pojo.EsQueryParams;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchPhraseQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.springframework.stereotype.Component;

@Component
public class EsBaseDao {
    private static Logger logger = LogManager.getLogger(EsBaseDao.class);

    public GetResponse searchDocument(EsQueryParams params) {
        TransportClient client = params.getClient();
        String typeName = params.getTypeName();
        String indexName = params.getIndexName();
        logger.info("typeName: " + typeName + "   ::::   indexName: " + indexName);
        String id = params.getId();
        GetResponse response = (GetResponse)client.prepareGet(indexName, typeName, String.valueOf(id)).get();
        return response;
    }

    public SearchResponse faceter(EsQueryParams params) {
        TransportClient client = params.getClient();
        String typeName = params.getTypeName();
        String indexName = params.getIndexName();
        logger.info("typeName: " + typeName + "   ::::   indexName: " + indexName);
        QueryBuilder query = params.getQuery();
        List<AggregationBuilder> aggs = params.getAggs();
        SearchRequestBuilder builder = client.prepareSearch(new String[]{indexName}).setTypes(new String[]{typeName}).setQuery(query);
        if (aggs != null && !aggs.isEmpty()) {
            for (AggregationBuilder agg : aggs) {
                builder.addAggregation(agg);
            }
        }
        SearchResponse response = (SearchResponse)builder.execute().actionGet();
        return response;
    }

    public SearchResponse searcher(EsQueryParams params) {
        TransportClient client = params.getClient();
        String typeName = params.getTypeName();
        String indexName = params.getIndexName();
        logger.info("typeName: " + typeName + "   ::::   indexName: " + indexName);
        QueryBuilder query = params.getQuery();
        int[] pos = params.getPos();
        Collection<FieldSortBuilder> sort = params.getSort();
        SearchRequestBuilder requestBuilder = client.prepareSearch(new String[]{indexName}).setTypes(new String[]{typeName}).setQuery(query).setFrom(pos[0]).setSize(pos[1]);
        if (sort != null && sort.size() > 0) {
            sort.forEach(x -> requestBuilder.addSort((SortBuilder)x));
        }
        SearchResponse response = (SearchResponse)requestBuilder.execute().actionGet();
        return response;
    }

    public Boolean delete(EsQueryParams params, String id) {
        TransportClient client = params.getClient();
        String indexName = params.getIndexName();
        String typeName = params.getTypeName();
        if (StringUtils.isBlank((CharSequence)id)) {
            return false;
        }
        logger.info("typeName: " + typeName + "   ::::   indexName: " + indexName);
        DeleteRequestBuilder deleteRequestBuilder = client.prepareDelete(indexName, typeName, id);
        DeleteResponse deleteResponse = (DeleteResponse)deleteRequestBuilder.get();
        return deleteResponse.status().name().equalsIgnoreCase("ok");
    }

    public Boolean update(EsQueryParams params, String urlMD5, Map<String, Object> data) {
        TransportClient client = params.getClient();
        String indexName = params.getIndexName();
        String typeName = params.getTypeName();
        if (StringUtils.isBlank((CharSequence)urlMD5)) {
            return false;
        }
        logger.info("typeName: " + typeName + "   ::::   indexName: " + indexName);
        UpdateRequestBuilder crawler = client.prepareUpdate(indexName, typeName, urlMD5).setDoc(data);
        UpdateResponse updateResponse = (UpdateResponse)crawler.execute().actionGet();
        RestStatus status = updateResponse.status();
        return status.name().equalsIgnoreCase("ok");
    }

    public Boolean index(EsQueryParams esQueryParams, NewsInfo bean) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        TransportClient client = esQueryParams.getClient();
        String indexName = esQueryParams.getIndexName();
        String typeName = esQueryParams.getTypeName();
        logger.info("typeName: " + typeName + "   ::::   indexName: " + indexName);
        IndexRequestBuilder crawler = client.prepareIndex(indexName, typeName).setId(bean.getUrlMD5()).setSource(mapper.writeValueAsString((Object)bean), XContentType.JSON);
        IndexResponse indexResponse = (IndexResponse)crawler.execute().actionGet();
        RestStatus status = indexResponse.status();
        return status.name().equalsIgnoreCase("ok") ? true : status.name().equalsIgnoreCase("created");
    }

    public NewsInfo selectByMD5url(EsQueryParams esQueryParams) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        TransportClient client = esQueryParams.getClient();
        String indexName = esQueryParams.getIndexName();
        String typeName = esQueryParams.getTypeName();
        QueryBuilder query = esQueryParams.getQuery();
        logger.info("typeName: " + typeName + "   ::::   indexName: " + indexName);
        SearchRequestBuilder requestBuilder = client.prepareSearch(new String[]{indexName}).setTypes(new String[]{typeName}).setQuery(query).setFrom(0).setSize(10);
        SearchResponse response = (SearchResponse)requestBuilder.execute().actionGet();
        SearchHit[] hits = response.getHits().getHits();
        NewsInfo bean = null;
        if (hits.length > 0) {
            Map source = response.getHits().getHits()[0].getSource();
            Object o = source.get("keywords");
            String keywords = null;
            if (o != null) {
                keywords = o.toString();
            }
            if ("[]".equals(keywords)) {
                source.put("keywords", "");
            }
            bean = (NewsInfo)mapper.convertValue((Object)response.getHits().getHits()[0].getSource(), NewsInfo.class);
        }
        return bean;
    }

    public static void text01(String[] args) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        EsQueryParams params = new EsQueryParams("2");
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        MatchPhraseQueryBuilder urlMD5 = null;
        urlMD5 = QueryBuilders.matchPhraseQuery((String)"urlMD5", (Object)MD5.md5("http://mp.weixin.qq.com/s?__biz=MzAxOTE5OTU2Nw==&mid=2651248740&idx=2&sn=de930269376048111b88ea5333364ce6&chksm=8038db44b74f52527f0a54a551ce381ed9be6647aa373b06d3606234406f5ac2415c44e4a658&scene=27#wechat_redirect"));
        query.must((QueryBuilder)urlMD5);
        params.setQuery((QueryBuilder)query);
        EsBaseDao esBaseDao = new EsBaseDao();
        NewsInfo newsInfo = esBaseDao.selectByMD5url(params);
        String[] strings = new String[]{"\u201c\u4e24\u6cbb\u4e00\u6574\u201d\u4e13\u9879\u884c\u52a8\u4eae\u5251\u201c", "\u201c\u8b66\u201d\u8272\u5e74\u534e | \u6211\u7684\u9752\u6625\u5ba3\u8a00", "\u5efa\u5fb7\u5e02\u6c14\u8c61\u53f0\u53d1\u5e03\u5927\u96fe\u9ec4\u8272\u9884\u8b66", "\u4ea4\u901a\u8fdd\u6cd5\u65f6\u5b9e\u63d0\u9192 \u5efa\u5fb7\u88c5\u4e0a\u4e86\u8fd9\u4e2a\u4f1a\u8bf4\u8bdd\u7684\u906e\u9633\u68da"};
        String[] times = new String[]{"2020-05-07 13:00:00", "2020-06-03 12:52:22", "2020-06-03 12:54:43", "2020-06-03 12:55:34", "2020-06-03 12:56:46", "2020-06-03 12:57:25", "2020-06-03 13:05:14"};
        String[] sourceName = new String[]{"\u65b0\u7586\u65e5\u62a5", "\u4e91\u5357\u65e5\u62a5", "\u6d77\u5357\u5357\u65e5\u62a5", "\u90a2\u53f0\u65e5\u62a5", "\u5408\u80a5\u5728\u7ebf_\u56fd\u5185\u8981\u95fb", "\u5317\u65b9\u7f51_\u65b0\u95fb", "\u5929\u6d25\u65e5\u62a5"};
        int length = strings.length;
        for (int i = 0; i < length; ++i) {
            newsInfo.setId(newsInfo.getId() + (long)i + 1L);
            newsInfo.setRefererUrl(newsInfo.getRefererUrl() + i);
            newsInfo.setUrlMD5(MD5.md5(newsInfo.getRefererUrl()));
            String string = strings[i];
            String time = times[i];
            String source = sourceName[i];
            newsInfo.setSubject(string);
            long timeNum = 1588831200000L;
            try {
                Date parse = dateFormat.parse(time);
                timeNum = parse.getTime();
                newsInfo.setCreateAtStr(parse);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            newsInfo.setEmotionScore(-new Double(Math.random() * 16.0 + 83.0).intValue());
            newsInfo.setParentSource(source);
            newsInfo.setTbNickname(source);
            newsInfo.setSiteName(source);
            newsInfo.setReprint(source);
            newsInfo.setSourceName(source);
            newsInfo.setCreatedAt(timeNum);
            newsInfo.setPubTime(timeNum);
            newsInfo.setCreatedAtStr(time);
            newsInfo.setPubTimeStr(time);
            newsInfo.setClusterId(newsInfo.getId());
            newsInfo.setCluster(string);
            esBaseDao.index(params, newsInfo);
            System.out.println(newsInfo.getUrlMD5());
        }
    }

    public static void main(String[] args) throws JsonProcessingException, ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        EsQueryParams params = new EsQueryParams("2");
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        MatchPhraseQueryBuilder urlMD5 = null;
        urlMD5 = QueryBuilders.matchPhraseQuery((String)"urlMD5", (Object)MD5.md5("http://news.weather.com.cn/2020/08/3375012.shtml"));
        query.must((QueryBuilder)urlMD5);
        params.setQuery((QueryBuilder)query);
        EsBaseDao esBaseDao = new EsBaseDao();
        NewsInfo newsInfo = esBaseDao.selectByMD5url(params);
        esBaseDao.update(params, MD5.md5(newsInfo.getRefererUrl()), (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("emotionScore", 0);
                this.put("emotionTendency", 0);
            }
        });
    }
}

