/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.parser;

import com.chinamcloud.haihe.common.bean.NewsInfo;
import com.chinamcloud.haihe.common.pojo.TableNews;
import com.chinamcloud.haihe.es.parser.BaseParser;
import com.chinamcloud.haihe.es.result.EsPagedResult;
import com.chinamcloud.haihe.es.result.EsSearchResult;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class TableNewsParser
implements BaseParser<List<TableNews>, EsPagedResult<EsSearchResult>> {
    private SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);

    @Override
    public List<TableNews> parseRecords(EsPagedResult<EsSearchResult> result) {
        ArrayList<TableNews> news = new ArrayList<TableNews>();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (NewsInfo apsFeedback : ((EsSearchResult)result.getResult()).getRecords()) {
            TableNews tableNews = new TableNews();
            tableNews.setTitle(apsFeedback.getSubject());
            tableNews.setUrl(apsFeedback.getRefererUrl());
            tableNews.setSource(apsFeedback.getSource());
            if (StringUtils.isNotBlank((CharSequence)apsFeedback.getSiteName())) {
                tableNews.setSiteName(apsFeedback.getSiteName());
            } else {
                tableNews.setSiteName(apsFeedback.getTbNickname());
            }
            Long pubTime = apsFeedback.getPubTime();
            if (pubTime == null) {
                if (apsFeedback.getPubTimeStr() != null) {
                    tableNews.setPubTime(format.format(apsFeedback.getPubTimeStr()));
                }
            } else {
                String time = format.format(new Date(pubTime));
                tableNews.setPubTime(time);
            }
            tableNews.setEmotionTendency(apsFeedback.getEmotionTendency());
            String description = apsFeedback.getDescription();
            if (StringUtils.isNotBlank((CharSequence)description)) {
                description = description.replace("`n`", "").replace("[[+_+]]", "").replace("nbsp;", "").trim();
            }
            tableNews.setDescription(description);
            news.add(tableNews);
        }
        return news;
    }
}

