/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.pojo;

import com.chinamcloud.haihe.es.config.EsFeedbackQuery;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;

public class EsBuildSort {
    private static Logger logger = LogManager.getLogger(EsBuildSort.class);

    public static Collection<FieldSortBuilder> getSearchSort(EsFeedbackQuery feedbackQuery) {
        List<String> sortingMethods = feedbackQuery.getSortingMethods();
        String filed = "pointsCount";
        SortOrder order = SortOrder.DESC;
        LinkedList<FieldSortBuilder> fieldSortBuilders = new LinkedList<FieldSortBuilder>();
        if (sortingMethods != null && sortingMethods.size() > 0) {
            sortingMethods.forEach(x -> {
                if (StringUtils.isNotBlank((CharSequence)x)) {
                    String[] words = x.split(" ");
                    SortOrder tmpOrder = order;
                    if (words.length == 2 && "asc".equalsIgnoreCase(words[1])) {
                        tmpOrder = SortOrder.ASC;
                    }
                    fieldSortBuilders.add((FieldSortBuilder)SortBuilders.fieldSort((String)words[0]).order(tmpOrder));
                }
            });
        } else {
            fieldSortBuilders.add((FieldSortBuilder)SortBuilders.fieldSort((String)filed).order(order));
        }
        return fieldSortBuilders;
    }

    public static FieldSortBuilder getFacetSort(EsFeedbackQuery feedbackQuery) {
        String[] words;
        List<String> sortingMethods = feedbackQuery.getSortingMethods();
        String filed = "pointsCount";
        SortOrder order = SortOrder.DESC;
        if (sortingMethods != null && sortingMethods.size() > 0 && (words = sortingMethods.get(0).split(" ")).length == 2) {
            filed = words[0];
            if (words[1].equals("asc")) {
                order = SortOrder.ASC;
            }
        }
        FieldSortBuilder sortBuilder = (FieldSortBuilder)SortBuilders.fieldSort((String)filed).order(order);
        return sortBuilder;
    }
}

