/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.result;

import com.chinamcloud.haihe.es.bean.EsApsFacetField;
import com.chinamcloud.haihe.es.config.EsFeedbackQuery;
import com.chinamcloud.haihe.es.result.EsFacetResult;
import com.chinamcloud.haihe.es.result.EsResultProcessor;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.terms.LongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.springframework.util.ObjectUtils;

public class EsFacetResultProcessor
implements EsResultProcessor<EsFacetResult<List<EsApsFacetField>>> {
    @Override
    public EsFacetResult<List<EsApsFacetField>> processResult(EsFeedbackQuery query, SearchResponse response) {
        String name = query.getFacetField();
        EsFacetResult<List<EsApsFacetField>> facetResult = null;
        try {
            ArrayList<EsApsFacetField> list = new ArrayList<EsApsFacetField>();
            MultiBucketsAggregation agg = (MultiBucketsAggregation)response.getAggregations().get("agg");
            EsApsFacetField apsFacetField = new EsApsFacetField();
            ArrayList<String> values = new ArrayList<String>();
            ArrayList<Long> counts = new ArrayList<Long>();
            ArrayList<EsApsFacetField> esApsFacetFields = new ArrayList<EsApsFacetField>();
            for (MultiBucketsAggregation.Bucket entry : agg.getBuckets()) {
                Aggregation agg1;
                Object key = entry.getKey();
                long docCount = entry.getDocCount();
                if (ObjectUtils.isEmpty((Object)key)) continue;
                values.add(String.valueOf(key));
                counts.add(docCount);
                Aggregations aggregations = entry.getAggregations();
                if (aggregations == null || (agg1 = aggregations.get("agg1")) == null) continue;
                try {
                    List buckets = ((LongTerms)agg1).getBuckets();
                    EsApsFacetField apsFacetField1 = new EsApsFacetField();
                    ArrayList<String> values1 = new ArrayList<String>();
                    ArrayList<Long> counts1 = new ArrayList<Long>();
                    for (Terms.Bucket bucket : buckets) {
                        Object key1 = bucket.getKey();
                        if (ObjectUtils.isEmpty((Object)key1)) continue;
                        long docCount1 = bucket.getDocCount();
                        values1.add(String.valueOf(key1));
                        counts1.add(docCount1);
                    }
                    apsFacetField1.setValues(values1);
                    apsFacetField1.setCounts(counts1);
                    esApsFacetFields.add(apsFacetField1);
                }
                catch (Exception exception) {}
            }
            apsFacetField.setEsApsFacetFields(esApsFacetFields);
            apsFacetField.setName(name);
            apsFacetField.setValues(values);
            apsFacetField.setCounts(counts);
            list.add(apsFacetField);
            facetResult = new EsFacetResult(list, (Boolean)true);
        }
        catch (Exception e) {
            facetResult = new EsFacetResult<List<EsApsFacetField>>(e.getMessage(), (Boolean)false);
        }
        return facetResult;
    }

    @Override
    public EsFacetResult<List<EsApsFacetField>> processResultByAgg(EsFeedbackQuery query, SearchResponse response) {
        return null;
    }
}

